/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.dsls.tcs.extractor;

import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.m2m.atl.dsls.tcs.extractor.ModelAdapter;
import org.eclipse.m2m.atl.dsls.tcs.extractor.TCSExtractionException;
import org.eclipse.m2m.atl.dsls.tcs.extractor.TCSExtractorPrintStream;
import org.eclipse.m2m.atl.dsls.tcs.extractor.TCSExtractorStream;

public class PrettyPrinter {
    private Map templates = new HashMap();
    private Map primitiveTemplates = new HashMap();
    private Map tokens = new HashMap();
    private Collection keywords = new ArrayList();
    private boolean kwCheckIgnoreCase;
    private String identEscStart = "\"";
    private String identEscEnd = "\"";
    private String stringDelim = "'";
    private boolean serializeComments = true;
    private boolean usePrimitiveTemplates = false;
    private static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    private DecimalFormat df = new DecimalFormat("0.##############", dfs);
    private TCSExtractorStream out;
    private Stack priorities = new Stack();
    private Stack currentSeparator = new Stack();
    private int indentLevel = 0;
    private String indentString = "  ";
    private String curIndent = "";
    private String standardSeparator = " ";
    private String lineFeed = "\n";
    private ModelAdapter modelAdapter;
    private static final int TYPE_KEYWORD = 1;
    private static final int TYPE_SYMBOL = 2;
    private static final int TYPE_IDENT = 3;
    private static final int TYPE_BOOL = 4;
    private static final int TYPE_INT = 5;
    private static final int TYPE_REAL = 6;
    private static final int TYPE_STRING = 7;
    private static final int TYPE_SPACE = 8;
    private static final int TYPE_COMMENT = 9;
    private static final int SYMBOL_LS = 16;
    private static final int SYMBOL_RS = 32;
    private static final int SYMBOL_BS = 48;
    private static final int SYMBOL_LN = 64;
    private static final int SYMBOL_RN = 128;
    private int typeLast = 0;
    private Map symbols = new HashMap();
    private boolean debug = false;
    private boolean debugws = false;

    static {
        dfs.setDecimalSeparator('.');
    }

    public void prettyPrint(Object source, ModelAdapter ma, OutputStream target, Map arguments) {
        String value;
        String name;
        Object ame;
        String decimalFormat;
        String stringDelim;
        String identEsc;
        String identEscEnd;
        this.modelAdapter = ma;
        this.out = (TCSExtractorStream)arguments.get("stream");
        if (this.out == null) {
            this.out = new TCSExtractorPrintStream(target);
        }
        String newIndentString = (String)arguments.get("indentString");
        String newStandardSeparator = (String)arguments.get("standardSeparator");
        this.kwCheckIgnoreCase = "true".equals(arguments.get("kwCheckIgnoreCase"));
        this.debug = "true".equals(arguments.get("debug"));
        this.debugws = "true".equals(arguments.get("debugws"));
        this.serializeComments = !"false".equals(arguments.get("serializeComments"));
        this.usePrimitiveTemplates = "true".equals(arguments.get("usePrimitiveTemplates"));
        String identEscStart = (String)arguments.get("identEscStart");
        if (identEscStart != null) {
            this.identEscStart = identEscStart;
        }
        if ((identEscEnd = (String)arguments.get("identEscEnd")) != null) {
            this.identEscEnd = identEscEnd;
        }
        if ((identEsc = (String)arguments.get("identEsc")) != null) {
            this.identEscStart = identEsc;
            this.identEscEnd = identEsc;
        }
        if ((stringDelim = (String)arguments.get("stringDelim")) != null) {
            this.stringDelim = stringDelim;
        }
        if ((decimalFormat = (String)arguments.get("decimalFormat")) != null) {
            this.df = new DecimalFormat(decimalFormat, dfs);
        }
        if (newIndentString != null) {
            this.indentString = newIndentString;
        }
        if (newStandardSeparator != null) {
            this.standardSeparator = newStandardSeparator;
        }
        Object format = arguments.get("format");
        String rootName = null;
        Object rootTemplate = null;
        Iterator i = this.modelAdapter.getElementsByType(format, "Template").iterator();
        while (i.hasNext()) {
            ame = i.next();
            name = this.modelAdapter.getString(ame, "name");
            boolean isMain = false;
            if ("ClassTemplate".equals(this.modelAdapter.getTypeName(ame))) {
                isMain = this.modelAdapter.getBool(ame, "isMain");
            }
            if (isMain) {
                rootName = name;
                rootTemplate = ame;
            }
            if (this.modelAdapter.getTypeName(ame).equals("EnumerationTemplate")) {
                HashMap<String, Object> mappings = new HashMap<String, Object>();
                Iterator j = this.modelAdapter.getCol(ame, "mappings");
                while (j.hasNext()) {
                    Object mapping = j.next();
                    mappings.put(this.modelAdapter.getString(this.modelAdapter.getME(mapping, "literal"), "name"), this.modelAdapter.getME(mapping, "element"));
                }
                this.templates.put(name, mappings);
                continue;
            }
            if (this.modelAdapter.getTypeName(ame).equals("PrimitiveTemplate")) {
                this.primitiveTemplates.put(name, ame);
                name = this.modelAdapter.getString(ame, "typeName");
                ArrayList c = (ArrayList)this.templates.get(name);
                if (c == null) {
                    c = new ArrayList();
                    this.templates.put(name, c);
                }
                c.add(ame);
                continue;
            }
            this.templates.put(name, ame);
        }
        i = this.modelAdapter.getElementsByType(format, "Keyword").iterator();
        while (i.hasNext()) {
            ame = i.next();
            value = this.modelAdapter.getString(ame, "value");
            if (this.kwCheckIgnoreCase) {
                value = value.toUpperCase();
            }
            this.keywords.add(value);
        }
        i = this.modelAdapter.getElementsByType(format, "Token").iterator();
        while (i.hasNext()) {
            ame = i.next();
            name = this.modelAdapter.getString(ame, "name");
            this.tokens.put(name, ame);
        }
        i = this.modelAdapter.getElementsByType(format, "Symbol").iterator();
        while (i.hasNext()) {
            ame = i.next();
            value = this.modelAdapter.getString(ame, "value");
            this.debug("Symbol: " + value);
            int type = 2;
            Iterator j = this.modelAdapter.getCol(ame, "spaces");
            while (j.hasNext()) {
                String l = this.modelAdapter.getEnumLiteralName(j.next());
                this.debug("\tLiteral: " + l);
                if (l.equals("leftSpace")) {
                    type += 16;
                } else if (l.equals("leftNone")) {
                    type += 64;
                }
                if (l.equals("rightSpace")) {
                    type += 32;
                    continue;
                }
                if (!l.equals("rightNone")) continue;
                type += 128;
            }
            this.symbols.put(value, new Integer(type));
        }
        Iterator possibleRoots = this.modelAdapter.getElementsByType(source, rootName).iterator();
        boolean isMulti = this.modelAdapter.getBool(rootTemplate, "isMulti");
        boolean first = true;
        while (possibleRoots.hasNext()) {
            Object root = possibleRoots.next();
            if (this.modelAdapter.isAModelElement(this.modelAdapter.refImmediateComposite(root))) continue;
            if (!isMulti && !first) {
                System.out.println("Error: multiple possible roots found.");
                break;
            }
            this.priorities.push(new Integer(Integer.MAX_VALUE));
            this.serialize(root);
            first = false;
        }
        if (first && !isMulti) {
            System.out.println("Error: no root found.");
        }
        this.out.close();
    }

    private void pushSep(String sep) {
        this.currentSeparator.push(sep);
        this.debug("PUSHING SEPARATOR: \"" + sep + "\"");
    }

    private void popSep() {
        String old = (String)this.currentSeparator.pop();
        this.debug("POPING SEPARATOR: \"" + old + "\"");
    }

    private void serialize(Object ame) {
        this.pushSep(this.standardSeparator);
        String typeName = this.modelAdapter.getTypeName(ame);
        this.debug("processing " + typeName);
        Object template = this.templates.get(typeName);
        if (template == null) {
            throw new TCSExtractionException("cannot find mathing template for: " + typeName, null);
        }
        String templateTypeName = this.modelAdapter.getTypeName(template);
        this.debug("Applying template type " + templateTypeName);
        if (this.serializeComments) {
            try {
                boolean first = true;
                boolean nl = false;
                Iterator i = this.modelAdapter.getCol(ame, "commentsBefore");
                while (i.hasNext()) {
                    String c = this.modelAdapter.nextString(i);
                    if (c.equals("\n")) {
                        nl = true;
                        continue;
                    }
                    this.debug("printing comment: \"" + c + "\"");
                    if (first && !nl) {
                        this.printComment(c);
                    } else {
                        this.printComment(c);
                    }
                    this.printWS(String.valueOf(this.lineFeed) + this.curIndent);
                    first = false;
                }
            }
            catch (Exception e) {
                System.out.println("Warning: could not get comments of " + ame + ", disabling further comments serialization");
                this.serializeComments = false;
            }
        }
        if (templateTypeName.equals("ClassTemplate")) {
            this.priorities.push(new Integer(Integer.MAX_VALUE));
            this.serializeSeq(ame, this.modelAdapter.getME(template, "templateSequence"));
            this.priorities.pop();
        } else if (templateTypeName.equals("OperatorTemplate")) {
            Object literal;
            String sourcePropName = this.modelAdapter.getString(template, "source");
            String opPropName = this.modelAdapter.getString(template, "storeOpTo");
            String rightPropName = this.modelAdapter.getString(template, "storeRightTo");
            this.debug("OperatorTemplate: source = " + sourcePropName + " ; operator = " + opPropName + " ; right = " + rightPropName);
            Object r = null;
            boolean isPostfix = false;
            boolean isUnary = false;
            isUnary = rightPropName != null ? ((r = this.modelAdapter.get(ame, rightPropName)) instanceof Collection ? ((Collection)r).size() == 0 : r == null) : true;
            this.debug("rightPropName = " + rightPropName + " ; isUnary = " + isUnary);
            Object operator = null;
            if (opPropName != null) {
                String op = this.modelAdapter.getString(ame, opPropName);
                if (op == null) {
                    throw new RuntimeException("Property " + opPropName + " has not been set in " + ame + " (" + this.modelAdapter.getMetaobject(ame) + ")");
                }
                Iterator i = this.modelAdapter.getCol(template, "operators");
                while (i.hasNext() && operator == null) {
                    Object opme = i.next();
                    literal = this.modelAdapter.getME(opme, "literal");
                    String opmes = null;
                    opmes = literal == null ? "" : this.modelAdapter.getString(literal, "value");
                    int arity = this.modelAdapter.getInt(opme, "arity");
                    if (!op.equals(opmes)) continue;
                    if (rightPropName != null) {
                        if ((!isUnary || arity != 1) && (isUnary || arity != 2)) continue;
                        operator = opme;
                        continue;
                    }
                    operator = opme;
                    isPostfix = this.modelAdapter.getBool(opme, "isPostfix");
                }
                if (operator == null) {
                    System.err.println("Error: could not find operator \"" + op + "\"");
                }
            } else {
                operator = this.modelAdapter.getCol(template, "operators").next();
                boolean bl = isUnary = this.modelAdapter.getInt(operator, "arity") == 1;
                if (isUnary) {
                    isPostfix = this.modelAdapter.getBool(operator, "isPostfix");
                }
            }
            int curPrio = (Integer)this.priorities.peek();
            int priority = this.modelAdapter.getInt(this.modelAdapter.getME(operator, "priority"), "value");
            boolean paren = priority > curPrio;
            this.priorities.push(new Integer(priority));
            literal = this.modelAdapter.getME(operator, "literal");
            this.debug("PRIORITY = " + priority + " ; CURPRIO = " + curPrio + " ; OPERATOR = " + (literal != null ? this.modelAdapter.getString(literal, "value") : "") + " ; paren = " + paren);
            if (paren) {
                this.printSymbol("(");
            }
            Object source = this.modelAdapter.getME(ame, sourcePropName);
            if (isUnary) {
                if (isPostfix) {
                    this.serialize(source);
                    if (literal != null) {
                        this.printLiteral(literal);
                    }
                } else {
                    if (literal != null) {
                        this.printLiteral(literal);
                    }
                    this.serialize(source);
                }
            } else {
                this.serialize(source);
                if (literal != null) {
                    this.printLiteral(literal);
                }
            }
            Object seq = this.modelAdapter.getME(template, "otSequence");
            if (rightPropName == null) {
                this.priorities.push(new Integer(Integer.MAX_VALUE));
                this.serializeSeq(ame, seq);
                this.priorities.pop();
            } else {
                if (seq != null) {
                    this.serializeSeq(ame, seq);
                }
                if (r instanceof Collection) {
                    Iterator i = ((Collection)r).iterator();
                    while (i.hasNext()) {
                        this.serialize(i.next());
                    }
                } else if (!isUnary) {
                    this.serialize(r);
                }
            }
            this.priorities.pop();
            if (paren) {
                this.printSymbol(")");
            }
        } else {
            this.error("unsupported template type: " + templateTypeName);
        }
        if (this.serializeComments) {
            try {
                Iterator i = this.modelAdapter.getCol(ame, "commentsAfter");
                while (i.hasNext()) {
                    String c = this.modelAdapter.nextString(i);
                    if (c.equals("\n")) continue;
                    this.printComment(c);
                    this.printWS(String.valueOf(this.lineFeed) + this.curIndent);
                }
            }
            catch (Exception e) {
                System.out.println("Warning: could not get comments of " + ame + ", disabling further comments serialization");
                this.serializeComments = false;
            }
        }
        this.popSep();
    }

    private void serializeSeq(Object ame, Object seq) {
        if (seq != null) {
            Iterator i = this.modelAdapter.getCol(seq, "elements");
            while (i.hasNext()) {
                Object e = i.next();
                this.serializeSeqElem(ame, e);
            }
        }
    }

    private String getLineFeeds(int n) {
        String ret = "";
        int i = 0;
        while (i < n) {
            ret = String.valueOf(ret) + this.lineFeed;
            ++i;
        }
        return ret;
    }

    private void serializeSeqElem(Object element, Object seqElem) {
        String tn = this.modelAdapter.getTypeName(seqElem);
        this.debug("serializing seq elem " + tn);
        if (tn.equals("LiteralRef")) {
            Object literal = this.modelAdapter.getME(seqElem, "referredLiteral");
            this.printLiteral(literal);
        } else if (tn.equals("CustomSeparator")) {
            String name = this.modelAdapter.getString(seqElem, "name");
            if (name.equals("no_space")) {
                this.typeLast = 130;
            } else if (name.equals("space")) {
                this.printWS(" ");
            } else if (name.equals("newline")) {
                this.printWS(this.lineFeed);
            } else if (name.equals("tab")) {
                this.printWS("\t");
            }
        } else if (tn.equals("Property")) {
            Object v = this.modelAdapter.get(element, this.modelAdapter.getString(seqElem, "name"));
            this.serializeProperty(element, v, seqElem);
        } else if (tn.equals("Block")) {
            if (this.debugws) {
                this.out.debug("<block>");
            }
            Object nbNLBArg = PrettyPrinter.getBArg(this.modelAdapter, seqElem, "NbNL");
            Object startNbNLBArg = PrettyPrinter.getBArg(this.modelAdapter, seqElem, "StartNbNL");
            Object indentIncrBArg = PrettyPrinter.getBArg(this.modelAdapter, seqElem, "IndentIncr");
            Object startNLBArg = PrettyPrinter.getBArg(this.modelAdapter, seqElem, "StartNL");
            Object endNLBArg = PrettyPrinter.getBArg(this.modelAdapter, seqElem, "EndNL");
            int indentIncr = 1;
            int nbNL = 1;
            boolean startNL = true;
            boolean endNL = true;
            if (nbNLBArg != null) {
                nbNL = this.modelAdapter.getInt(nbNLBArg, "value");
            }
            int startNbNL = nbNL;
            if (startNbNLBArg != null) {
                startNbNL = this.modelAdapter.getInt(startNbNLBArg, "value");
            }
            if (indentIncrBArg != null) {
                indentIncr = this.modelAdapter.getInt(indentIncrBArg, "value");
            }
            if (startNLBArg != null) {
                startNL = this.modelAdapter.getBool(startNLBArg, "value");
            }
            if (endNLBArg != null) {
                endNL = this.modelAdapter.getBool(endNLBArg, "value");
            }
            this.debug("nbNL = " + nbNL + " ; indentIncr = " + indentIncr);
            this.indentLevel += indentIncr;
            int i = 0;
            while (i < indentIncr) {
                this.curIndent = String.valueOf(this.curIndent) + this.indentString;
                ++i;
            }
            String nls = this.getLineFeeds(nbNL);
            this.pushSep(String.valueOf(nls) + (nbNL == 0 ? this.standardSeparator : this.curIndent));
            if (this.debugws) {
                this.out.debug("<BeforeFirstWS/>");
            }
            if (startNL) {
                if (startNbNL == 0) {
                    this.printWS("");
                } else if (nbNL == startNbNL) {
                    this.printWS();
                } else {
                    this.printWS(String.valueOf(this.getLineFeeds(startNbNL)) + this.curIndent);
                }
            } else {
                if (this.debugws) {
                    this.out.debug("<BeforeNonStartNLWS/>");
                }
                this.printWS("");
                if (this.debugws) {
                    this.out.debug("<AfterNonStartNLWS/>");
                }
            }
            if (this.debugws) {
                this.out.debug("<blockContent>");
            }
            this.serializeSeq(element, this.modelAdapter.getME(seqElem, "blockSequence"));
            if (this.debugws) {
                this.out.debug("</blockContent>");
            }
            this.indentLevel -= indentIncr;
            this.curIndent = this.curIndent.substring(0, this.curIndent.length() - this.indentString.length() * indentIncr);
            if (endNL) {
                this.printWS(String.valueOf(this.lineFeed) + this.curIndent);
            }
            this.popSep();
            if (this.debugws) {
                this.out.debug("</block>");
            }
        } else if (tn.equals("FunctionCall")) {
            this.serializeSeq(element, this.modelAdapter.getME(this.modelAdapter.getME(seqElem, "calledFunction"), "functionSequence"));
        } else if (tn.equals("ConditionalElement")) {
            Object condition = this.modelAdapter.getME(seqElem, "condition");
            if (this.eval(element, condition)) {
                Object tseq = this.modelAdapter.getME(seqElem, "thenSequence");
                if (tseq != null) {
                    this.printWSBlockNoDup();
                }
                this.serializeSeq(element, tseq);
            } else {
                Object eseq = this.modelAdapter.getME(seqElem, "elseSequence");
                this.debug("ELSE SEQ = " + eseq);
                if (eseq != null) {
                    this.printWSBlockNoDup();
                }
                this.serializeSeq(element, eseq);
            }
        } else {
            this.error("unsupported: " + tn);
        }
    }

    private boolean eval(Object context, Object condition) {
        boolean ret = true;
        String ctn = this.modelAdapter.getTypeName(condition);
        if (ctn.equals("AndExp")) {
            ret = true;
            Iterator i = this.modelAdapter.getCol(condition, "expressions");
            while (i.hasNext()) {
                ret &= this.eval(context, i.next());
            }
        } else if (ctn.equals("BooleanPropertyExp")) {
            ret = this.modelAdapter.getBool(context, this.modelAdapter.getString(condition, "propertyName"));
        } else if (ctn.equals("IsDefinedExp")) {
            Object val = this.modelAdapter.get(context, this.modelAdapter.getString(condition, "propertyName"));
            ret = val == null ? false : (val instanceof Collection ? ((Collection)val).size() > 0 : true);
            if (this.modelAdapter.getString(condition, "propertyName").equals("superRule")) {
                this.debug("!!!superRule: " + ret + " " + val);
            }
        } else if (ctn.equals("OneExp")) {
            Object val = this.modelAdapter.get(context, this.modelAdapter.getString(condition, "propertyName"));
            ret = val == null ? false : (val instanceof Collection ? ((Collection)val).size() == 1 : true);
            if (this.modelAdapter.getString(condition, "propertyName").equals("superRule")) {
                this.debug("!!!superRule: " + ret + " " + val);
            }
        } else if (ctn.equals("EqualsExp")) {
            Object value = this.modelAdapter.getME(condition, "value");
            String vtn = this.modelAdapter.getTypeName(value);
            if (vtn.equals("IntegerVal")) {
                int pv;
                int lv = this.modelAdapter.getInt(value, "symbol");
                ret = lv == (pv = this.modelAdapter.getInt(context, this.modelAdapter.getString(condition, "propertyName")));
            } else if (vtn.equals("NegativeIntegerVal")) {
                int pv;
                int lv = -this.modelAdapter.getInt(value, "symbol");
                ret = lv == (pv = this.modelAdapter.getInt(context, this.modelAdapter.getString(condition, "propertyName")));
            } else if (vtn.equals("StringVal")) {
                String lv = this.modelAdapter.getString(value, "symbol");
                String pv = this.modelAdapter.getString(context, this.modelAdapter.getString(condition, "propertyName"));
                ret = lv.equals(pv);
            } else if (vtn.equals("EnumLiteralVal")) {
                String lv = this.modelAdapter.getString(value, "name");
                String pv = this.modelAdapter.getString(context, this.modelAdapter.getString(condition, "propertyName"));
                ret = lv.equals(pv);
            } else {
                this.error(String.valueOf(vtn) + " unsupported.");
            }
        }
        return ret;
    }

    private void serializeProperty(Object element, Object value, Object property) {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Object sep = PrettyPrinter.getPArg(this.modelAdapter, property, "Separator");
            if (sep != null) {
                sep = this.modelAdapter.getME(sep, "separatorSequence");
            }
            boolean first = true;
            Iterator i = ((Collection)value).iterator();
            while (i.hasNext()) {
                if (first) {
                    this.printWSBlockNoDup();
                    first = false;
                } else if (this.typeLast != 8) {
                    this.printWS();
                }
                this.serializeProperty(element, i.next(), property);
                if (!i.hasNext() || sep == null) continue;
                this.serializeSeq(null, sep);
            }
        } else if (this.modelAdapter.isEnumLiteral(value)) {
            String enumName = this.modelAdapter.getName(this.modelAdapter.getPropertyType(this.modelAdapter.getMetaobject(element), this.modelAdapter.getName(property)));
            Map mappings = (Map)this.templates.get(enumName);
            Object seqElem = mappings.get(this.modelAdapter.getEnumLiteralName(value));
            this.serializeSeqElem(element, seqElem);
        } else if (this.modelAdapter.isAModelElement(value)) {
            this.printWSBlockNoDup();
            Object refersTo = PrettyPrinter.getPArg(this.modelAdapter, property, "RefersTo");
            if (refersTo == null) {
                this.serialize(value);
            } else {
                Object v = this.modelAdapter.get(value, this.modelAdapter.getString(refersTo, "propertyName"));
                Object asp = PrettyPrinter.getPArg(this.modelAdapter, property, "As");
                String as = null;
                if (asp != null) {
                    as = this.modelAdapter.getString(asp, "value");
                }
                this.serializePrimitive(v, as);
            }
        } else if (this.modelAdapter.isPrimitive(value)) {
            this.printWSBlockNoDup();
            Object asp = PrettyPrinter.getPArg(this.modelAdapter, property, "As");
            String as = null;
            if (asp != null) {
                as = this.modelAdapter.getString(asp, "value");
            }
            this.serializePrimitive(value, as);
        } else {
            this.error("unsupported " + (value == null ? null : value.getClass()));
        }
    }

    private void serializePrimitive(Object value, String as) {
        if (value instanceof String) {
            boolean doDefault = true;
            if (this.usePrimitiveTemplates) {
                Collection c = (Collection)this.templates.get("String");
                Object t = null;
                Iterator i = c.iterator();
                while (i.hasNext() && t == null) {
                    Object ame = i.next();
                    if (as == null && this.modelAdapter.getBool(ame, "isDefault")) {
                        t = ame;
                        continue;
                    }
                    if (!this.modelAdapter.getString(ame, "name").equals(as)) continue;
                    t = ame;
                }
                if (t == null) {
                    System.out.println("warning: no primitive template found for String" + (as == null ? "" : "as " + as));
                } else {
                    String tokenName = this.modelAdapter.getString(t, "tokenName");
                    Object token = this.tokens.get(tokenName);
                    if (token != null) {
                        System.out.println("Token found: " + tokenName);
                        Object pattern = this.modelAdapter.getME(token, "pattern");
                        String regex = "^" + this.buildRegex(pattern) + "$";
                        System.out.println(regex);
                        String val = (String)value;
                        System.out.println(val);
                        System.out.println(val.matches(regex));
                    }
                }
            }
            if (doDefault) {
                if ("stringSymbol".equals(as)) {
                    this.printStringLiteral(PrettyPrinter.cString((String)value));
                } else {
                    Object template = this.primitiveTemplates.get(as);
                    boolean orKeyword = false;
                    if (template != null) {
                        orKeyword = this.modelAdapter.getBoolUndefinedIsFalse(template, "orKeyword");
                    }
                    this.printIdentifier((String)value, orKeyword);
                }
            }
        } else if (value instanceof Integer) {
            this.printIntegerLiteral((Integer)value);
        } else if (value instanceof Double) {
            this.printRealLiteral((Double)value);
        } else if (value instanceof Boolean) {
            this.printBooleanLiteral((Boolean)value);
        }
    }

    private static String cString(String s) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                ret.append("\\n");
            } else if (c == '\r') {
                ret.append("\\r");
            } else if (c == '\t') {
                ret.append("\\t");
            } else if (c == '\b') {
                ret.append("\\b");
            } else if (c == '\f') {
                ret.append("\\f");
            } else if (c < ' ' || c > '~' && c < '\u00a1') {
                ret.append("\\");
                if (c < '\b') {
                    ret.append("0");
                }
                if (c < '@') {
                    ret.append("0");
                }
                ret.append(Integer.toOctalString(c));
            } else if (c == '\'') {
                ret.append("\\'");
            } else if (c == '\"') {
                ret.append("\\\"");
            } else if (c == '\\') {
                ret.append("\\\\");
            } else {
                ret.append(c);
            }
            ++i;
        }
        return "" + ret;
    }

    private String buildRegex(Object pattern) {
        String ret = null;
        String typeName = this.modelAdapter.getTypeName(pattern);
        if (typeName.equals("OrPattern")) {
            boolean paren = false;
            Iterator i = this.modelAdapter.getCol(pattern, "simplePatterns");
            while (i.hasNext()) {
                Object p = i.next();
                if (ret == null) {
                    ret = this.buildRegex(p);
                    continue;
                }
                paren = true;
                ret = String.valueOf(ret) + "|" + this.buildRegex(p);
            }
            if (paren) {
                ret = "(" + ret + ")";
            }
        } else if (typeName.equals("RulePattern")) {
            Object rule = this.modelAdapter.getME(pattern, "rule");
            String rtn = this.modelAdapter.getTypeName(rule);
            if (rtn.equals("WordRule")) {
                ret = "(";
                ret = String.valueOf(ret) + this.buildRegex(this.modelAdapter.getME(rule, "start"));
                ret = String.valueOf(ret) + this.buildRegex(this.modelAdapter.getME(rule, "part")) + "*";
                Object end = this.modelAdapter.getME(rule, "end");
                if (end != null) {
                    ret = String.valueOf(ret) + this.buildRegex(end);
                }
                ret = String.valueOf(ret) + ")";
            } else if (rtn.equals("MultiLineRule")) {
                ret = "(";
                String endRegex = this.buildRegex(this.modelAdapter.getME(rule, "end"));
                String middleRegex = "[^" + endRegex + "]";
                Object esc = this.modelAdapter.getME(rule, "esc");
                if (esc != null) {
                    String escRegex = this.buildRegex(esc);
                    middleRegex = "(" + middleRegex + "|" + escRegex + ".)";
                }
                ret = String.valueOf(ret) + middleRegex + "*";
                ret = String.valueOf(ret) + ")";
            } else {
                this.error("unsupported rule type: " + rtn);
            }
        } else if (typeName.equals("StringPattern")) {
            String name = this.modelAdapter.getString(pattern, "name");
            ret = name.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\*", "\\\\*").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+");
        } else if (typeName.equals("ClassPattern")) {
            String name = this.modelAdapter.getString(pattern, "name");
            ret = "\\p{" + ("" + name.charAt(0)).toUpperCase() + name.substring(1) + "}";
        } else {
            this.error("unsupported pattern type: " + typeName);
        }
        return ret;
    }

    private void printLiteral(Object literal) {
        String s = this.modelAdapter.getString(literal, "value");
        String ltn = this.modelAdapter.getTypeName(literal);
        if (ltn.equals("Keyword")) {
            this.printKeyword(s);
        } else {
            this.printSymbol(s);
        }
    }

    private void printWS(String ws) {
        this.debug("printing WS = \"" + ws + "\"");
        this.out.printWhiteSpace(ws);
        this.typeLast = 8;
    }

    private void printWS() {
        this.printWS((String)this.currentSeparator.peek());
    }

    private boolean isSymbol(int type, int test) {
        return (type & (test += 2)) == test;
    }

    private void printDisambiguationWS() {
        if (this.typeLast == 1 || this.typeLast == 3 || this.typeLast == 5 || this.typeLast == 6 || this.typeLast == 7 || this.typeLast == 4 || this.isSymbol(this.typeLast, 48) || this.isSymbol(this.typeLast, 32)) {
            this.printWS();
        }
    }

    private void printWSBlockNoDup() {
        if (this.typeLast != 8 && !this.currentSeparator.peek().equals(" ")) {
            this.printWS();
        }
    }

    private void printWSNoDup() {
        if (this.typeLast != 8) {
            this.printWS();
        }
    }

    private void printKeyword(String keyword) {
        this.printDisambiguationWS();
        this.out.printKeyword(keyword);
        this.typeLast = 1;
    }

    private void printSymbol(String symbol) {
        Integer type = (Integer)this.symbols.get(symbol);
        int typeCurrent = -1;
        typeCurrent = type == null ? 2 : type;
        if ((this.isSymbol(typeCurrent, 16) || this.isSymbol(typeCurrent, 48)) && !this.isSymbol(this.typeLast, 128) || (this.isSymbol(this.typeLast, 32) || this.isSymbol(this.typeLast, 48)) && !this.isSymbol(typeCurrent, 64)) {
            this.printWSNoDup();
        }
        this.out.printSymbol(symbol);
        this.typeLast = typeCurrent;
    }

    private void printIdentifier(String ident, boolean orKeyword) {
        this.printDisambiguationWS();
        boolean simpleIdent = ident.matches("[_a-zA-Z][_a-zA-Z0-9]*");
        if (simpleIdent && !orKeyword) {
            boolean bl = simpleIdent = !this.keywords.contains(ident);
        }
        if (!orKeyword && this.kwCheckIgnoreCase && this.keywords.contains(ident.toUpperCase())) {
            simpleIdent = false;
        }
        if (simpleIdent) {
            this.out.printIdentifier(ident);
        } else {
            this.out.printEscapedIdentifier(this.identEscStart, ident, this.identEscEnd);
        }
        this.typeLast = 3;
    }

    private void printBooleanLiteral(boolean v) {
        this.printDisambiguationWS();
        this.out.printBoolean(v);
        this.typeLast = 4;
    }

    private void printIntegerLiteral(int v) {
        this.printDisambiguationWS();
        this.out.printInteger(v);
        this.typeLast = 5;
    }

    private void printRealLiteral(double v) {
        this.printDisambiguationWS();
        this.out.printReal(this.df.format(v));
        this.typeLast = 6;
    }

    private void printStringLiteral(String v) {
        this.printDisambiguationWS();
        this.out.printString(this.stringDelim, v);
        this.typeLast = 7;
    }

    private void printComment(String c) {
        this.printDisambiguationWS();
        this.out.printComment(c);
        this.typeLast = 9;
    }

    private static Object getPArg(ModelAdapter ma, Object ame, String name) {
        Object ret = null;
        Iterator i = ma.getCol(ame, "propertyArgs");
        while (i.hasNext() && ret == null) {
            Object arg = i.next();
            if (!ma.getTypeName(arg).equals(String.valueOf(name) + "PArg")) continue;
            ret = arg;
        }
        return ret;
    }

    private static Object getBArg(ModelAdapter ma, Object ame, String name) {
        Object ret = null;
        Iterator i = ma.getCol(ame, "blockArgs");
        while (i.hasNext() && ret == null) {
            Object arg = i.next();
            if (!ma.getTypeName(arg).equals(String.valueOf(name) + "BArg")) continue;
            ret = arg;
        }
        return ret;
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    private void error(String msg) {
        System.out.println("ERROR: " + msg);
    }
}

