/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.debug.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.WorkspaceQvtModule;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;

public class QVTOApplicationConfiguration
extends EclipseApplicationLaunchConfiguration {
    private final List<URI> fModels = new ArrayList<URI>();
    private URI fTraceURI;

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String traceFileURI;
        String[] programArguments = super.getProgramArguments(configuration);
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(programArguments));
        String transformationURI = QvtLaunchUtil.getTransformationURI((ILaunchConfiguration)configuration);
        if (transformationURI != null) {
            result.add(QVTOApplicationConfiguration.createArgStr("-transform", this.createPlatformURI(transformationURI).toString()));
        }
        if ((traceFileURI = QvtLaunchUtil.getTraceFileURI((ILaunchConfiguration)configuration)) != null && traceFileURI.trim().length() != 0) {
            this.fTraceURI = QVTODebugUtil.toFileURI((String)traceFileURI);
            result.add(QVTOApplicationConfiguration.createArgStr("-trace", this.fTraceURI.toString()));
        }
        if (QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)configuration) && this.fTraceURI != null) {
            result.add("-trace_save");
        }
        if (QvtLaunchUtil.isIncrementalUpdate((ILaunchConfiguration)configuration) && this.fTraceURI != null) {
            result.add("-trace_incremental");
        }
        List<QvtTransformation.TransformationParameter.DirectionKind> transfParams = this.getTransfParams(transformationURI);
        int paramIndex = 0;
        List modelURIs = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)configuration);
        for (TargetUriData targetUriData : modelURIs) {
            String nextURI = targetUriData.getUriString();
            boolean isPlatformUri = paramIndex < transfParams.size() && transfParams.get(paramIndex++) == QvtTransformation.TransformationParameter.DirectionKind.IN;
            URI nextModelURI = isPlatformUri ? this.createPlatformURI(nextURI) : QVTODebugUtil.toFileURI((String)nextURI);
            this.fModels.add(nextModelURI);
            result.add(QVTOApplicationConfiguration.createArgStr("-param", nextModelURI.toString()));
        }
        List<String> mappings = this.createMetamodelMappings(transformationURI);
        for (String m : mappings) {
            result.add(QVTOApplicationConfiguration.createArgStr("-mmapings", m));
        }
        return result.toArray(new String[result.size()]);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.reset();
        configuration = this.validateLaunchConfiguration(configuration);
        super.launch(configuration, mode, launch, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
        IProcess p = this.getProcess(launch);
        if (p != null) {
            this.addTerminationHook(p);
        }
    }

    ILaunchConfiguration validateLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute("application", "org.eclipse.m2m.qvt.oml.debug.core.QVTOApplication");
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            QVTODebugCore.log((IStatus)e.getStatus());
            return configuration;
        }
    }

    IProcess getProcess(ILaunch launch) {
        IProcess[] launchedProcesses = launch.getProcesses();
        if (launchedProcesses.length == 0) {
            return null;
        }
        return launchedProcesses[0];
    }

    private URI createPlatformURI(String uriStr) {
        URI uri = URI.createURI((String)uriStr, (boolean)true);
        IFile file = this.getIFile(uriStr);
        if (file != null) {
            URI platformPluginURI = QVTODebugCore.getDefault().resolvePlatformPluginURI(file);
            if (platformPluginURI != null) {
                return platformPluginURI;
            }
            if (uri.isPlatformResource()) {
                URI baseURI = URI.createURI((String)ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString());
                uri = URI.createURI((String)(String.valueOf(baseURI.toString()) + uri.toPlatformString(true)), (boolean)true);
            }
        }
        return uri;
    }

    private IFile getIFile(String uriStr) {
        try {
            URI uri = URI.createURI((String)uriStr);
            IFile file = QVTODebugUtil.toFile((URI)uri);
            if (file != null && file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static String createArgStr(String argName, String argValue) {
        return String.valueOf(argName) + "=" + argValue;
    }

    private List<String> createMetamodelMappings(String transformationURI) throws CoreException {
        IFile file = this.getIFile(transformationURI);
        if (file == null) {
            return Collections.emptyList();
        }
        if (!MetamodelURIMappingHelper.hasMappingResource((IProject)file.getProject())) {
            return Collections.emptyList();
        }
        try {
            MappingContainer mappings = MetamodelURIMappingHelper.loadMappings((IProject)file.getProject());
            ArrayList<String> args = new ArrayList<String>(mappings.getMapping().size());
            for (URIMapping m : mappings.getMapping()) {
                args.add(String.valueOf(m.getSourceURI()) + ';' + this.createPlatformURI(m.getTargetURI()).toString());
            }
            return args;
        }
        catch (Exception e) {
            throw new CoreException(QVTODebugCore.createStatus((int)4, (String)"Failed to load metamodel mappings", (Throwable)e));
        }
    }

    private List<QvtTransformation.TransformationParameter.DirectionKind> getTransfParams(String transformationURI) throws CoreException {
        IFile file = this.getIFile(transformationURI);
        if (file == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<QvtTransformation.TransformationParameter.DirectionKind> params = new ArrayList<QvtTransformation.TransformationParameter.DirectionKind>(2);
            for (QvtTransformation.TransformationParameter p : new WorkspaceQvtModule(file).getParameters()) {
                params.add(p.getDirectionKind());
            }
            return params;
        }
        catch (MdaException e) {
            QVTODebugCore.log((IStatus)QVTODebugCore.createStatus((int)4, (String)"Failed to load transformation", (Throwable)e));
            return Collections.emptyList();
        }
    }

    private void addTerminationHook(final IProcess process) {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getSource() == process && event.getKind() == 8) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        QVTOApplicationConfiguration.this.onTerminate();
                    }
                    ++n2;
                }
            }
        });
        if (process.isTerminated()) {
            this.onTerminate();
        }
    }

    private void onTerminate() {
        QVTODebugUtil.refreshInWorkspace(this.fModels);
        if (this.fTraceURI != null) {
            QVTODebugUtil.refreshInWorkspace(Collections.singletonList(this.fTraceURI));
        }
    }

    protected void reset() {
        this.fModels.clear();
        this.fTraceURI = null;
    }
}

