/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PathEditorInput
implements IPathEditorInput {
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();
    private IPath path;

    public PathEditorInput(IPath path) {
        this.path = path;
    }

    public IPath getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.path.toFile().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/heapobjects/heapdump16.gif");
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.path.toOSString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbenchAdapter.class.equals(adapter)) {
            return adapter.cast(this.fWorkbenchAdapter);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object obj) {
        return obj instanceof IPathEditorInput && ((IPathEditorInput)obj).getPath().toOSString().equals(this.path.toOSString());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private static class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((PathEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

