/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.diagnostics;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsAction;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsProgress;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DiagnosticsExecutionWizardPage
extends WizardPage
implements DiagnosticsProgress {
    private boolean isExecuting;
    private Label introLabel;
    private Text status;

    public DiagnosticsExecutionWizardPage() {
        super("diagnostics_execution");
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.DiagnosticsExecutionWizardPage_DialogName);
        this.setDescription(Messages.DiagnosticsExecutionWizardPage_DialogDescription);
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.introLabel = new Label(top, 0);
        this.introLabel.setText(Messages.DiagnosticsExecutionWizardPage_IntroIdle);
        this.introLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.status = new Text(top, 2626);
        this.status.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)top);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.diagnostics");
    }

    public void reset() {
        this.introLabel.setText(Messages.DiagnosticsExecutionWizardPage_IntroIdle);
        this.clearText();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.mat.ui.help.diagnostics");
    }

    public boolean performFinish(DiagnosticsAction action) {
        this.isExecuting = true;
        try {
            this.introLabel.setText(Messages.DiagnosticsExecutionWizardPage_IntroExecuting);
            this.clearText();
            DiagnosticExecutionRunnable operation = new DiagnosticExecutionRunnable(action, this, (IRunnableContext)this.getContainer());
            if (operation.run().isOK()) {
                this.introLabel.setText(Messages.DiagnosticsExecutionWizardPage_SucceededExecuting);
                this.setTextboxColor();
                return true;
            }
            this.introLabel.setText(Messages.DiagnosticsExecutionWizardPage_IntroIdle);
            this.setTextboxColor();
        }
        finally {
            this.isExecuting = false;
        }
        return false;
    }

    private void setTextboxColor() {
    }

    public boolean isPageComplete() {
        return !this.isExecuting;
    }

    @Override
    public void appendText(final String text) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DiagnosticsExecutionWizardPage.this.status.isDisposed()) {
                    return;
                }
                String newText = DiagnosticsExecutionWizardPage.this.status.getText();
                newText = newText == null || newText.length() == 0 ? text : String.valueOf(newText) + Text.DELIMITER + text;
                DiagnosticsExecutionWizardPage.this.status.setText(newText);
            }
        });
    }

    @Override
    public void handleException(Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.appendText(sw.toString().replaceAll("\n", Text.DELIMITER));
        }
    }

    @Override
    public void clearText() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DiagnosticsExecutionWizardPage.this.status.isDisposed()) {
                    return;
                }
                DiagnosticsExecutionWizardPage.this.status.setText("");
            }
        });
    }

    private static class DiagnosticExecutionRunnable
    implements IRunnableWithProgress {
        private IStatus status;
        private IRunnableContext context;
        private DiagnosticsAction action;
        private DiagnosticsProgress progress;

        public DiagnosticExecutionRunnable(DiagnosticsAction action, DiagnosticsProgress progress, IRunnableContext context) {
            this.action = action;
            this.context = context;
            this.progress = progress;
        }

        public final IStatus run() {
            try {
                this.context.run(true, true, (IRunnableWithProgress)this);
            }
            catch (Exception e) {
                this.status = ErrorHelper.createErrorStatus(Messages.AcquireSnapshotAction_UnexpectedException, e);
            }
            if (!this.status.isOK() && this.status != Status.CANCEL_STATUS) {
                String error = MessageUtil.format((String)Messages.DiagnosticsExecutionWizardPage_ErrorExecuting, (Object[])new Object[]{this.status.getException().getLocalizedMessage()});
                Logger.getLogger("org.eclipse.mat.ui").log(Level.SEVERE, error, this.status.getException());
                this.progress.appendText(error);
                this.progress.handleException(this.status.getException());
            }
            return this.status;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.status = this.doOperation(monitor);
        }

        private IStatus doOperation(IProgressMonitor monitor) {
            ProgressMonitorWrapper listener = new ProgressMonitorWrapper(monitor);
            try {
                this.action.run(this.progress);
                if (listener.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                return ErrorHelper.createErrorStatus(e);
            }
            return Status.OK_STATUS;
        }
    }
}

