/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.mat.util.PatternUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TextEditor
extends ArgumentEditor {
    protected Object value;
    protected Text text;
    protected Composite parent;
    protected DecoratorType decorator;

    public TextEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item, DecoratorType decorator) {
        super(parent, context, descriptor, item);
        this.setBackground(parent.getBackground());
        this.parent = parent;
        this.decorator = decorator;
        this.createContents();
    }

    public TextEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        this(parent, context, descriptor, item, null);
        this.setFont(item.getFont());
        this.setBackground(item.getBackground());
    }

    protected void createContents() {
        this.setLayout((Layout)new FillLayout());
        this.text = new Text((Composite)this, 16384);
        this.text.setFont(this.item.getFont());
        this.text.setBackground(this.item.getBackground());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    TextEditor.this.editingDone();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextEditor.this.editingDone();
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (TextEditor.this.descriptor.getAdvice() == Argument.Advice.CLASS_NAME_PATTERN) {
                    TextEditor.this.text.setText(PatternUtil.smartFix((String)TextEditor.this.text.getText(), (boolean)false));
                }
            }
        });
    }

    protected void editingDone() {
        try {
            this.fireErrorEvent(null, this);
            String t = this.text.getText().trim();
            this.value = t.length() == 0 ? null : this.context.convertToValue(this.descriptor.getType(), this.descriptor.getAdvice(), t);
            this.fireValueChangedEvent(this.value, this);
        }
        catch (SnapshotException e) {
            this.fireErrorEvent(e.getMessage(), this);
        }
    }

    @Override
    public void setValue(Object value) throws SnapshotException {
        this.value = value;
        this.text.setText(this.context.convertToString(this.descriptor.getType(), this.descriptor.getAdvice(), value));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    public DecoratorType getDecorator() {
        return this.decorator;
    }

    public static enum DecoratorType {
        PATTERN("$nl$/icons/heapobjects/class.gif", Messages.TextEditor_EnterPattern, "pattern"),
        OBJECT_ADDRESS("$nl$/icons/id.gif", Messages.TextEditor_EnterAddress, "address"),
        QUERY("$nl$/icons/oql.gif", Messages.TextEditor_EnterOQLQuery, "oql_query");

        private String imageType;
        private String helpText;
        private String helpLink;

        private DecoratorType(String imageType, String helpText, String helpLink) {
            this.imageType = imageType;
            this.helpText = helpText;
            this.helpLink = helpLink;
        }

        public Image getImage() {
            return MemoryAnalyserPlugin.getImage(this.imageType);
        }

        public String getImageType() {
            return this.imageType;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getHelpLink() {
            return this.helpLink;
        }
    }
}

