/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.uicore.UnwrappingSelectionProvider;
import org.eclipse.modisco.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.editorInputs.ResourceEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public final class BrowserUtils {
    private BrowserUtils() {
    }

    public static URIConverter createURIConverter() {
        List defaultHandlers = URIHandler.DEFAULT_HANDLERS;
        ArrayList<Object> uriHandlers = new ArrayList<Object>();
        for (URIHandler uriHandler : defaultHandlers) {
            if (uriHandler.getClass() == URIHandlerImpl.class) continue;
            uriHandlers.add(uriHandler);
        }
        uriHandlers.add(new URIHandlerImpl(){

            public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
                return new HashMap();
            }
        });
        return new ExtensibleURIConverterImpl(uriHandlers, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
    }

    public static int askUserForDepthToLoadReferencedResources(int initialValue, final Shell shell) {
        final IInputValidator validator = new IInputValidator(){

            public String isValid(String inputText) {
                if ("*".equals(inputText)) {
                    return null;
                }
                try {
                    Integer.parseInt(inputText);
                }
                catch (NumberFormatException e) {
                    return NLS.bind((String)Messages.EcoreBrowser_notAPositiveInteger, (Object)inputText);
                }
                return null;
            }
        };
        final String initialValueStr = initialValue == -1 ? "*" : Integer.toString(initialValue);
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                InputDialog inputDialog = new InputDialog(shell, Messages.EcoreBrowser_selectDepthReferencedResources, Messages.EcoreBrowser_modelContainsProxies + Messages.EcoreBrowser_chooseLoadProxiesDepth, initialValueStr, validator);
                if (inputDialog.open() == 0) {
                    String value = inputDialog.getValue();
                    if (value == null) {
                        result[0] = 0;
                    } else if ("*".equals(value)) {
                        result[0] = -1;
                    } else {
                        try {
                            result[0] = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            MoDiscoBrowserPlugin.logException(e);
                            result[0] = 0;
                        }
                    }
                }
            }
        });
        return result[0];
    }

    public static void handleCopyToClipboard(ISelection selection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            StringBuilder builder = new StringBuilder();
            Iterator iterator = treeSelection.iterator();
            while (iterator.hasNext()) {
                Object selectedElement;
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                if ((selectedElement = iterator.next()) instanceof ModelElementItem) {
                    ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
                    builder.append(modelElementItem.getName());
                    continue;
                }
                if (selectedElement instanceof AttributeItem) {
                    AttributeItem attributeItem = (AttributeItem)selectedElement;
                    String valueText = attributeItem.getValueText();
                    builder.append(valueText);
                    continue;
                }
                if (selectedElement instanceof LinkItem) {
                    LinkItem linkItem = (LinkItem)selectedElement;
                    builder.append(linkItem.getReference().getName());
                    continue;
                }
                if (selectedElement instanceof ITreeElement) {
                    ITreeElement treeElement = (ITreeElement)selectedElement;
                    builder.append(treeElement.getText());
                    continue;
                }
                builder.append(selectedElement.toString());
            }
            Clipboard clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{builder.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public static ISelection unwrapSelection(ISelection selection) {
        return UnwrappingSelectionProvider.unwrapSelection((ISelection)selection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void openEObjectInBrowser(EObject eObject, boolean useExistingEditor) {
        Resource resource;
        if (useExistingEditor && (resource = eObject.eResource()) != null) {
            IWorkbenchWindow[] workbenchWindows;
            ResourceSet resourceSet = resource.getResourceSet();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference[] editorReferences;
                    IWorkbenchPage workbenchPage = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = editorReferences = workbenchPage.getEditorReferences();
                    int n5 = editorReferences.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        EcoreBrowser browser;
                        IEditorReference editorReference = iEditorReferenceArray[n6];
                        IEditorPart anEditor = editorReference.getEditor(false);
                        if (anEditor instanceof EcoreBrowser && (browser = (EcoreBrowser)anEditor).getResourceSet() == resourceSet) {
                            browser.browseTo(eObject);
                            browser.getSite().getPage().activate((IWorkbenchPart)browser);
                            return;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            URIEditorInput editorInput;
            URI elementURI = EcoreUtil.getURI((EObject)eObject);
            URI resourceURI = elementURI.trimFragment();
            if (resourceURI.isPlatformResource()) {
                String platformString = resourceURI.toPlatformString(true);
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (!(res instanceof IFile)) {
                    MoDiscoBrowserPlugin.logError("Cannot open model: " + String.valueOf(resourceURI));
                    return;
                }
                IFile file = (IFile)res;
                editorInput = new FileEditorInput(file);
            } else if (EPackage.Registry.INSTANCE.containsKey((Object)resourceURI.toString())) {
                editorInput = new URIEditorInput(resourceURI);
            } else if (eObject.eResource() != null) {
                if (eObject.eResource().getResourceSet() == null) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResources().add((Object)eObject.eResource());
                }
                editorInput = new ResourceEditorInput(eObject.eResource());
            } else {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource tempResource = resourceSet.createResource(URI.createURI((String)"http://eclipse.org/MoDisco/browser/temp"));
                tempResource.getContents().add((Object)eObject);
                editorInput = new ResourceEditorInput(tempResource);
            }
            IEditorPart newEditor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)"org.eclipse.modisco.infra.browser.editorID", (boolean)true);
            if (!(newEditor instanceof EcoreBrowser)) return;
            final EcoreBrowser browser = (EcoreBrowser)newEditor;
            final String uriFragment = eObject.eResource().getURIFragment(eObject);
            browser.doWhenLoaded(new Runnable(){

                @Override
                public void run() {
                    boolean result = browser.browseToByURI(uriFragment);
                    if (!result) {
                        MoDiscoLogger.logError((String)("could not find EObject with uriFragment \"" + uriFragment + "\" in the model"), (Plugin)MoDiscoBrowserPlugin.getPlugin());
                    }
                }
            });
            return;
        }
        catch (PartInitException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
    }
}

