/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class GerritServerUtility {
    private static final String LAST_GERRIT_FILE = "lastGerrit.txt";
    private static final String LAST_COMMANDS_FILE = "lastCommands.txt";
    private final String ECLIPSE_GERRIT_DEFAULT = "https://git.eclipse.org/r/";
    private final String SLASH = "/";
    private static GerritServerUtility fInstance = null;
    private Map<TaskRepository, String> fResultTask = new HashMap<TaskRepository, String>();

    protected GerritServerUtility() {
        fInstance = this;
    }

    private void adjustTemplatemanager(TaskRepository aTaskRepo) {
        RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        boolean found = false;
        for (RepositoryTemplate template : templateManager.getTemplates("org.eclipse.mylyn.gerrit")) {
            String convertedRemoteURL = aTaskRepo.getRepositoryUrl();
            GerritPlugin.Ftracer.traceInfo("\t template.label: " + template.label + "\t repo label: " + aTaskRepo.getRepositoryLabel() + " repo getname: " + convertedRemoteURL);
            if (!template.label.equals(aTaskRepo.getRepositoryLabel()) && !template.repositoryUrl.equals(convertedRemoteURL)) continue;
            found = true;
            break;
        }
        if (!found) {
            String userName = aTaskRepo.getUserName();
            Boolean anonymous = userName == null || userName.isEmpty();
            RepositoryTemplate templateTest = new RepositoryTemplate(aTaskRepo.getRepositoryLabel(), aTaskRepo.getRepositoryUrl(), aTaskRepo.getCharacterEncoding(), aTaskRepo.getVersion(), "", "", "", aTaskRepo.getUserName(), anonymous.booleanValue(), true);
            Map attributes = aTaskRepo.getProperties();
            Set value = attributes.entrySet();
            for (Map.Entry entry : value) {
                templateTest.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            templateManager.addTemplate("org.eclipse.mylyn.gerrit", templateTest);
        }
    }

    private void printRepositoryTemplate() {
        RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        if (templateManager != null) {
            for (RepositoryTemplate template : templateManager.getTemplates("org.eclipse.mylyn.gerrit")) {
                GerritPlugin.Ftracer.traceInfo("------------======================------------------");
                Set value = template.getAttributes().entrySet();
                if (value == null) continue;
                for (Map.Entry entry : value) {
                    GerritPlugin.Ftracer.traceInfo("key: " + (String)entry.getKey() + "\tvalue: " + (String)entry.getValue());
                }
            }
        }
    }

    private File getLastGerritFile(String aFile) {
        IPath ipath = GerritPlugin.getDefault().getStateLocation();
        String fileName = ipath.append(aFile).toPortableString();
        File file = new File(fileName);
        return file;
    }

    private URL buildDocumentationURL(String aRequest) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        String lastSaved = GerritServerUtility.getInstance().getLastSavedGerritServer();
        if (lastSaved == null) {
            lastSaved = "https://git.eclipse.org/r/";
        }
        if (!lastSaved.endsWith("/")) {
            lastSaved = lastSaved.concat("/");
        }
        sb.append(lastSaved);
        sb.append(aRequest);
        return new URL(sb.toString());
    }

    private String getEditorId(URL aUrl) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(aUrl.getFile());
        String id = null;
        if (desc != null) {
            id = desc.getId();
        }
        return id;
    }

    public static GerritServerUtility getInstance() {
        if (fInstance == null) {
            new GerritServerUtility();
        }
        return fInstance;
    }

    public Map<TaskRepository, String> getGerritMapping() {
        if (this.fResultTask == null) {
            this.fResultTask = new HashMap<TaskRepository, String>();
        }
        this.fResultTask.clear();
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        if (repositoryManager != null) {
            GerritPlugin.Ftracer.traceInfo("--------Review repo ---------------");
            Set reviewRepo = repositoryManager.getRepositories("org.eclipse.mylyn.gerrit");
            if (reviewRepo != null) {
                for (TaskRepository taskRepo : reviewRepo) {
                    GerritPlugin.Ftracer.traceInfo("Add Gerrit Review repo: " + taskRepo.getRepositoryLabel() + "\t url: " + taskRepo.getRepositoryUrl());
                    this.fResultTask.put(taskRepo, taskRepo.getRepositoryUrl());
                    if (taskRepo.getRepositoryUrl() == null) continue;
                    this.adjustTemplatemanager(taskRepo);
                }
            }
            this.printRepositoryTemplate();
        }
        return this.fResultTask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean saveLastGerritServer(String aURL) {
        boolean ok = true;
        File file = this.getLastGerritFile(LAST_GERRIT_FILE);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileWriter fw = new FileWriter(file);
                try {
                    try (BufferedWriter out = new BufferedWriter(fw);){
                        out.write(aURL);
                    }
                    if (fw == null) return ok;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return ok;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            ok = false;
        }
        return ok;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLastSavedGerritServer() {
        String lastGerritURL = null;
        File file = this.getLastGerritFile(LAST_GERRIT_FILE);
        if (file == null) return lastGerritURL;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileReader fr = new FileReader(file);
                try {
                    try (BufferedReader in = new BufferedReader(fr);){
                        lastGerritURL = in.readLine();
                    }
                    if (fr == null) return lastGerritURL;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return lastGerritURL;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lastGerritURL;
    }

    public String getMenuSelectionURL(String aSt) {
        String urlStr = null;
        this.fResultTask = this.getGerritMapping();
        if (!this.fResultTask.isEmpty()) {
            Set<TaskRepository> mapSet = this.fResultTask.keySet();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            for (TaskRepository key : mapSet) {
                if (!key.getRepositoryLabel().equals(aSt)) continue;
                urlStr = this.fResultTask.get(key);
                GerritPlugin.Ftracer.traceInfo("Map Key: " + key.getRepositoryLabel() + "\t URL: " + this.fResultTask.get(key));
                return urlStr;
            }
        }
        return urlStr;
    }

    public TaskRepository getTaskRepo(String aStURL) {
        this.fResultTask = this.getGerritMapping();
        if (aStURL != null && !this.fResultTask.isEmpty()) {
            Set<TaskRepository> mapSet = this.fResultTask.keySet();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            for (TaskRepository key : mapSet) {
                if (!key.getRepositoryUrl().equals(aStURL)) continue;
                GerritPlugin.Ftracer.traceInfo("Key label : " + key.getRepositoryLabel() + "\t URL: " + this.fResultTask.get(key));
                return key;
            }
        }
        return null;
    }

    public void openWebBrowser(String aDocumentation) {
        if (fInstance == null) {
            fInstance = GerritServerUtility.getInstance();
        }
        IWorkbenchBrowserSupport workBenchSupport = PlatformUI.getWorkbench().getBrowserSupport();
        URL url = null;
        try {
            url = this.buildDocumentationURL(aDocumentation);
            try {
                String id = this.getEditorId(url);
                workBenchSupport.createBrowser(id).openURL(url);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        GerritUi.Ftracer.traceInfo("openWebBrowser for " + String.valueOf(url));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean saveLastCommandList(Set<String> aCommands) {
        boolean ok = true;
        File file = this.getLastGerritFile(LAST_COMMANDS_FILE);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileWriter fw = new FileWriter(file);
                try {
                    try (BufferedWriter out = new BufferedWriter(fw);){
                        for (String s : aCommands) {
                            out.write(s);
                            out.newLine();
                        }
                    }
                    if (fw == null) return ok;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return ok;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            ok = false;
        }
        return ok;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<String> getListLastCommands() {
        LinkedHashSet<String> lastCommands = new LinkedHashSet<String>();
        File file = this.getLastGerritFile(LAST_COMMANDS_FILE);
        if (file == null) return lastCommands;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileReader fr = new FileReader(file);
                try {
                    try (BufferedReader in = new BufferedReader(fr);){
                        while (in.ready()) {
                            String line = in.readLine();
                            lastCommands.add(line);
                        }
                    }
                    if (fr == null) return lastCommands;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return lastCommands;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lastCommands;
    }
}

