/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCompareUi;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.factories.AbstractPatchSetUiFactory;
import org.eclipse.mylyn.internal.gerrit.ui.factories.Messages;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;

public class OpenFileUiFactory
extends AbstractPatchSetUiFactory {
    private final IFileItem item;
    private final IComment comment;

    public OpenFileUiFactory(IUiContext context, IReviewItemSet set, IFileItem item) {
        this(context, set, item, null);
    }

    public OpenFileUiFactory(IUiContext context, IReviewItemSet set, IFileItem item, IComment comment) {
        super(Messages.OpenFileUiFactory_Open_File, context, set);
        this.item = item;
        this.comment = comment;
    }

    public void execute() {
        if (!this.isExecutable()) {
            this.handleExecutionStateError();
            return;
        }
        if (this.item.getBase() == null || this.item.getTarget() == null) {
            this.getEditor().setMessage(Messages.OpenFileUiFactory_File_not_available, 2);
            return;
        }
        GerritReviewBehavior behavior = new GerritReviewBehavior(this.getTask(), this.resolveGitRepository());
        CompareConfiguration configuration = new CompareConfiguration();
        GerritCompareUi.openFileComparisonEditor(configuration, this.item, (ReviewBehavior)behavior, this.comment);
    }

    public boolean isExecutable() {
        return this.getChange() != null;
    }
}

