/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

public class TaskAttributeMapper {
    private final TaskRepository taskRepository;

    public TaskAttributeMapper(@NonNull TaskRepository taskRepository) {
        Assert.isNotNull((Object)((Object)taskRepository));
        this.taskRepository = taskRepository;
    }

    public @NonNull TaskAttribute createTaskAttachment(@NonNull TaskData taskData) {
        TaskAttribute taskAttribute = taskData.getRoot().createAttribute(this.mapToRepositoryKey(taskData.getRoot(), "task.common.new.attachment"));
        return taskAttribute;
    }

    public boolean equals(@NonNull TaskAttribute newAttribute, @NonNull TaskAttribute oldAttribute) {
        if ("comment".equals(newAttribute.getMetaData().getType())) {
            if (newAttribute.getValues().equals(oldAttribute.getValues())) {
                return true;
            }
            if (oldAttribute != null) {
                TaskAttribute commentIdAttribute = oldAttribute.getAttribute("task.common.comment.id");
                if ((commentIdAttribute == null || commentIdAttribute.getValue().equals("")) && newAttribute.getValue().equals("")) {
                    return true;
                }
                if (commentIdAttribute != null && commentIdAttribute.getValue().equals(newAttribute.getValue())) {
                    return true;
                }
            }
        }
        return newAttribute.getValues().equals(oldAttribute.getValues());
    }

    public @Nullable TaskAttribute getAssoctiatedAttribute(@NonNull TaskAttribute taskAttribute) {
        String id = taskAttribute.getMetaDatum("task.meta.associated.attribute");
        if (id != null) {
            TaskAttribute associatedAttribute = taskAttribute.getAttribute(id);
            if (associatedAttribute != null) {
                return associatedAttribute;
            }
            return taskAttribute.getTaskData().getRoot().getAttribute(id);
        }
        return null;
    }

    public @Nullable TaskAttribute getAssoctiatedAttribute(@NonNull TaskOperation taskOperation) {
        TaskAttribute taskAttribute = taskOperation.getTaskAttribute();
        if (taskAttribute != null) {
            return this.getAssoctiatedAttribute(taskAttribute);
        }
        return null;
    }

    public @NonNull List<TaskAttribute> getAttributesByType(@NonNull TaskData taskData, @NonNull String type) {
        Assert.isNotNull((Object)taskData);
        Assert.isNotNull((Object)type);
        ArrayList<TaskAttribute> result = new ArrayList<TaskAttribute>();
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!type.equals(taskAttribute.getMetaData().getType())) continue;
            result.add(taskAttribute);
        }
        return result;
    }

    public boolean getBooleanValue(@NonNull TaskAttribute attribute) {
        String booleanString = attribute.getValue();
        if (booleanString != null && booleanString.length() > 0) {
            return Boolean.parseBoolean(booleanString);
        }
        return false;
    }

    public @Nullable Date getDateValue(@NonNull TaskAttribute attribute) {
        String dateString = attribute.getValue();
        try {
            if (dateString != null && dateString.length() > 0) {
                return new Date(Long.parseLong(dateString));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public @Nullable String getDefaultOption(@NonNull TaskAttribute taskAttribute) {
        return taskAttribute.getMetaData().getDefaultOption();
    }

    public @Nullable Double getDoubleValue(@NonNull TaskAttribute attribute) {
        String doubleString = attribute.getValue();
        try {
            if (doubleString != null) {
                return Double.parseDouble(doubleString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public @Nullable Integer getIntegerValue(@NonNull TaskAttribute attribute) {
        String integerString = attribute.getValue();
        try {
            if (integerString != null) {
                return Integer.parseInt(integerString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public @Nullable String getLabel(@NonNull TaskAttribute taskAttribute) {
        return taskAttribute.getMetaData().getLabel();
    }

    public @Nullable Long getLongValue(@NonNull TaskAttribute attribute) {
        String longString = attribute.getValue();
        try {
            if (longString != null) {
                return Long.parseLong(longString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public @NonNull Map<String, String> getOptions(@NonNull TaskAttribute attribute) {
        return attribute.getOptions();
    }

    public @NonNull IRepositoryPerson getRepositoryPerson(@NonNull TaskAttribute taskAttribute) {
        IRepositoryPerson person = this.taskRepository.createPerson(taskAttribute.getValue());
        TaskAttribute child = taskAttribute.getMappedAttribute("task.common.person.name");
        if (child != null) {
            person.setName(this.getValue(child));
        }
        return person;
    }

    public @NonNull List<TaskOperation> getTaskOperations(@NonNull TaskAttribute operationsAttribute) {
        Assert.isNotNull((Object)operationsAttribute);
        TaskData taskData = operationsAttribute.getTaskData();
        ArrayList<TaskOperation> result = new ArrayList<TaskOperation>();
        for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
            if (!"operation".equals(taskAttribute.getMetaData().getType()) || taskAttribute.getId().equals(this.mapToRepositoryKey(taskData.getRoot(), "task.common.operation"))) continue;
            result.add(TaskOperation.createFrom(taskAttribute));
        }
        return result;
    }

    public @NonNull TaskOperation getTaskOperation(@NonNull TaskAttribute taskAttribute) {
        Assert.isNotNull((Object)taskAttribute);
        return TaskOperation.createFrom(taskAttribute);
    }

    public @NonNull TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public @Nullable String getValue(@NonNull TaskAttribute taskAttribute) {
        return taskAttribute.getValue();
    }

    public @NonNull String getValueLabel(@NonNull TaskAttribute taskAttribute) {
        List<String> labels = this.getValueLabels(taskAttribute);
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String value : labels) {
            sb.append(sep).append(value);
            sep = ", ";
        }
        return sb.toString();
    }

    public @NonNull List<String> getValueLabels(@NonNull TaskAttribute taskAttribute) {
        List<String> values = taskAttribute.getValues();
        Map<String, String> options = this.getOptions(taskAttribute);
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (String value : values) {
            String option = options.get(value);
            if (option != null) {
                value = option;
            } else if (taskAttribute.getOption(value) != null) {
                value = taskAttribute.getOption(value);
            }
            result.add(value);
        }
        return result;
    }

    public @NonNull List<String> getValues(@NonNull TaskAttribute attribute) {
        return new ArrayList<String>(attribute.getValues());
    }

    public boolean hasValue(@NonNull TaskAttribute attribute) {
        return attribute.getValues().size() > 0;
    }

    public String mapToRepositoryKey(@NonNull TaskAttribute parent, @NonNull String key) {
        return key;
    }

    public void setBooleanValue(@NonNull TaskAttribute attribute, @NonNull Boolean value) {
        attribute.setValue(Boolean.toString(value));
    }

    public void setDateValue(@NonNull TaskAttribute attribute, @Nullable Date date) {
        if (date != null) {
            attribute.setValue(Long.toString(date.getTime()));
        } else {
            attribute.clearValues();
        }
    }

    public void setDoubleValue(@NonNull TaskAttribute attribute, @Nullable Double value) {
        if (value != null) {
            attribute.setValue(value.toString());
        } else {
            attribute.clearValues();
        }
    }

    public void setIntegerValue(@NonNull TaskAttribute attribute, @Nullable Integer value) {
        if (value != null) {
            attribute.setValue(value.toString());
        } else {
            attribute.clearValues();
        }
    }

    public void setLongValue(@NonNull TaskAttribute attribute, @Nullable Long value) {
        if (value != null) {
            attribute.setValue(value.toString());
        } else {
            attribute.clearValues();
        }
    }

    public void setRepositoryPerson(@NonNull TaskAttribute taskAttribute, @NonNull IRepositoryPerson person) {
        this.setValue(taskAttribute, person.getPersonId());
        if (person.getName() != null) {
            TaskAttribute child = taskAttribute.createAttribute("task.common.person.name");
            this.setValue(child, person.getName());
        }
    }

    public void setTaskOperation(@NonNull TaskAttribute taskAttribute, @NonNull TaskOperation taskOperation) {
        Assert.isNotNull((Object)taskAttribute);
        Assert.isNotNull((Object)taskOperation);
        TaskOperation.applyTo(taskAttribute, taskOperation.getOperationId(), taskOperation.getLabel());
    }

    public void setValue(@NonNull TaskAttribute attribute, @NonNull String value) {
        attribute.setValue(value);
    }

    public void setValues(@NonNull TaskAttribute attribute, @NonNull List<String> values) {
        attribute.setValues(values);
    }

    public void updateTaskAttachment(@NonNull ITaskAttachment taskAttachment, @NonNull TaskAttribute taskAttribute) {
        TaskAttachmentMapper.createFrom(taskAttribute).applyTo(taskAttachment);
    }

    public void updateTaskComment(@NonNull ITaskComment taskComment, @NonNull TaskAttribute taskAttribute) {
        TaskCommentMapper.createFrom(taskAttribute).applyTo(taskComment);
    }

    public ITask.PriorityLevel getPriorityLevel(TaskAttribute priorityAttribute, String priorityOption) {
        return ITask.PriorityLevel.fromString(priorityOption);
    }
}

