/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.commons.workbench.WorkbenchActionSupport;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskFromSelectionAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.RepositoryElementActionGroup;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;

public class TaskEditorActionGroup
extends RepositoryElementActionGroup {
    private final WorkbenchActionSupport actionSupport;
    private final SynchronizeEditorAction synchronizeEditorAction = new SynchronizeEditorAction();
    private final NewTaskFromSelectionAction newTaskFromSelectionAction = new NewTaskFromSelectionAction();

    public TaskEditorActionGroup(WorkbenchActionSupport actionSupport) {
        this.actionSupport = actionSupport;
        this.synchronizeEditorAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.synchronizeEditorAction.setEnabled(false);
    }

    public void fillContextMenu(IMenuManager manager, TaskEditor editor, boolean addClipboard) {
        ITask task = editor.getTaskEditorInput().getTask();
        SelectionProviderAdapter selectionProvider = new SelectionProviderAdapter();
        this.setSelectionProvider((ISelectionProvider)selectionProvider);
        selectionProvider.setSelection((ISelection)new StructuredSelection((Object)task));
        super.fillContextMenu(manager);
        if (addClipboard) {
            this.addClipboardActions(manager);
        }
        this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)editor));
        StructuredSelection selection = new StructuredSelection((Object)task);
        this.actionSupport.updateActions((ISelection)selection);
        this.newTaskFromSelectionAction.selectionChanged((ISelection)selection);
        manager.add((IContributionItem)new Separator());
        if (this.synchronizeEditorAction.isEnabled()) {
            manager.appendToGroup("repository", (IAction)this.synchronizeEditorAction);
        }
    }

    public void addClipboardActions(IMenuManager manager) {
        manager.prependToGroup("edit", (IAction)this.actionSupport.getCopyAction());
        manager.prependToGroup("edit", (IAction)this.actionSupport.getCutAction());
        manager.appendToGroup("edit", (IAction)this.actionSupport.getPasteAction());
        manager.appendToGroup("edit", (IAction)this.actionSupport.getSelectAllAction());
        manager.appendToGroup("edit", (IAction)this.newTaskFromSelectionAction);
    }

    public SynchronizeEditorAction getSynchronizeEditorAction() {
        return this.synchronizeEditorAction;
    }

    public NewTaskFromSelectionAction getNewTaskFromSelectionAction() {
        return this.newTaskFromSelectionAction;
    }
}

