/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.SecurityUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.BaseDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CredentialsDialog
extends BaseDialog<Viewer> {
    private static final String TITLE = Messages.getString("CredentialsDialog_0");
    private static final String MESSAGE = Messages.getString("CredentialsDialog_1");
    private static final int WIDTH = 400;
    private static final int HEIGHT = 225;
    private final String realm;
    private List<String> users;
    private Control userIDControl;
    private Text passwordControl;
    private IPasswordCredentials credentials;

    public CredentialsDialog(Shell shell) {
        this(shell, null);
    }

    public CredentialsDialog(Shell shell, String realm) {
        this(shell, realm, TITLE, MESSAGE);
    }

    public CredentialsDialog(Shell shell, String realm, String title, String message) {
        super(shell, 66800, title, message, OM.Activator.INSTANCE.getDialogSettings(), OM.getImageDescriptor("icons/credentials_wiz.gif"));
        this.realm = realm;
    }

    public final String getRealm() {
        return this.realm;
    }

    public IPasswordCredentials getCredentials() {
        return this.credentials;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.configureShell(newShell, 400, 225);
    }

    protected void configureShell(Shell newShell, int width, int height) {
        Composite parent = newShell.getParent();
        if (parent != null) {
            Rectangle bounds = parent.getBounds();
            int x = bounds.x + (bounds.width >> 1) - (width >> 1);
            int y = bounds.y + (bounds.height >> 1) - (height >> 1);
            newShell.setBounds(x, y, width, height);
        } else {
            newShell.setSize(width, height);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.updateOkButton();
        return buttonBar;
    }

    @Override
    protected void createUI(Composite parent) {
        this.users = this.loadUsers();
        this.createCredentialsArea(parent);
    }

    protected Composite createCredentialsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText(Messages.getString("CredentialsDialog_2"));
        this.userIDControl = this.createUserIDControl(composite);
        this.userIDControl.setLayoutData((Object)UIUtil.createGridData(true, false));
        new Label(composite, 0).setText(Messages.getString("CredentialsDialog_3"));
        this.passwordControl = new Text(composite, 0x400800);
        this.passwordControl.setLayoutData((Object)UIUtil.createGridData(true, false));
        if (this.userIDControl instanceof Combo) {
            this.passwordControl.setFocus();
        }
        return composite;
    }

    protected Control createUserIDControl(Composite composite) {
        if (this.users.isEmpty()) {
            Text text = new Text(composite, 2048);
            text.addModifyListener(e -> this.updateOkButton());
            return text;
        }
        Combo combo = new Combo(composite, 2048);
        combo.setItems(this.users.toArray(new String[this.users.size()]));
        combo.setText(this.getInitialUserID());
        combo.addModifyListener(e -> this.updateOkButton());
        return combo;
    }

    protected void okPressed() {
        String userID = this.getUserID();
        String password = this.passwordControl.getText();
        this.credentials = this.createCredentials(userID, SecurityUtil.toCharArray((String)password));
        this.users.remove(userID);
        this.users.add(0, userID);
        this.saveUsers(this.users);
        super.okPressed();
    }

    protected IPasswordCredentials createCredentials(String userID, char[] password) {
        return new PasswordCredentials(userID, password);
    }

    protected List<String> loadUsers() {
        String key;
        ArrayList<String> result = new ArrayList<String>();
        IDialogSettings settings = this.getUsersSection();
        String[] users = settings.getArray(key = this.getRealmKey());
        if (users != null && users.length != 0) {
            result.addAll(Arrays.asList(users));
        }
        return result;
    }

    protected void saveUsers(List<String> users) {
        IDialogSettings settings = this.getUsersSection();
        String key = this.getRealmKey();
        settings.put(key, users.toArray(new String[users.size()]));
    }

    protected String getInitialUserID() {
        return this.users.get(0);
    }

    private String getUserID() {
        if (this.userIDControl instanceof Combo) {
            return ((Combo)this.userIDControl).getText();
        }
        return ((Text)this.userIDControl).getText();
    }

    private String getRealmKey() {
        String key = "realm";
        if (this.realm != null) {
            key = String.valueOf(key) + this.realm;
        }
        return key;
    }

    private IDialogSettings getUsersSection() {
        return this.getDialogSettings("users");
    }

    private void updateOkButton() {
        this.getButton(0).setEnabled(this.getUserID().length() != 0);
    }
}

