/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.nio.ByteBuffer;
import org.eclipse.net4j.util.fsm.FiniteStateMachine;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.INegotiator;

public abstract class Negotiator<STATE extends Enum<?>, EVENT extends Enum<?>>
extends FiniteStateMachine<STATE, EVENT, INegotiationContext>
implements INegotiator,
INegotiationContext.Receiver {
    private transient STATE initialState;
    private transient STATE successState;
    private transient STATE failureState;
    private transient EVENT startEvent;
    private transient EVENT bufferEvent;
    private boolean initiator;

    public Negotiator(Class<STATE> stateEnum, Class<EVENT> eventEnum, STATE initialState, STATE successState, STATE failureState, EVENT startEvent, EVENT bufferEvent, boolean initiator) {
        super(stateEnum, eventEnum);
        if (initialState == null) {
            throw new IllegalStateException("initialState == null");
        }
        if (successState == null) {
            throw new IllegalStateException("successState == null");
        }
        if (failureState == null) {
            throw new IllegalStateException("failureState == null");
        }
        if (startEvent == null) {
            throw new IllegalStateException("startEvent == null");
        }
        if (bufferEvent == null) {
            throw new IllegalStateException("bufferEvent == null");
        }
        this.initialState = initialState;
        this.successState = successState;
        this.failureState = failureState;
        this.startEvent = startEvent;
        this.bufferEvent = bufferEvent;
        this.initiator = initiator;
    }

    public STATE getInitialState() {
        return this.initialState;
    }

    public STATE getSuccessState() {
        return this.successState;
    }

    public STATE getFailureState() {
        return this.failureState;
    }

    public EVENT getBufferEvent() {
        return this.bufferEvent;
    }

    public EVENT getStartEvent() {
        return this.startEvent;
    }

    @Override
    public boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public void negotiate(INegotiationContext context) {
        context.setReceiver(this);
        context.setState((Enum<?>)this.initialState);
        if (this.initiator) {
            this.process(context, this.startEvent, null);
            this.postProcess(context);
        }
    }

    @Override
    public void receiveBuffer(INegotiationContext context, ByteBuffer buffer) {
        this.process(context, this.bufferEvent, buffer);
        this.postProcess(context);
    }

    protected void postProcess(INegotiationContext context) {
        Enum<?> state = context.getState();
        if (state == this.successState) {
            this.handleSuccess(context);
        } else if (state == this.failureState) {
            this.handleFailure(context);
        }
    }

    protected void handleSuccess(INegotiationContext context) {
        context.setFinished(true);
    }

    protected void handleFailure(INegotiationContext context) {
        context.setFinished(false);
    }
}

