/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.spi.net4j;

import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.protocol.IProtocol3;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.spi.net4j.InternalChannel;

public abstract class Protocol<INFRA_STRUCTURE>
extends Lifecycle
implements IProtocol3<INFRA_STRUCTURE>,
IExecutorServiceProvider {
    private String type;
    private ExecutorService executorService;
    private IBufferProvider bufferProvider;
    private INFRA_STRUCTURE infraStructure;
    private IChannel channel;
    @ReflectUtil.ExcludeFromDump
    private transient IListener channelListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Protocol.this.handleChannelDeactivation();
        }
    };
    private String userID;

    public Protocol(String type) {
        this.type = type;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public IBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    @Override
    public INFRA_STRUCTURE getInfraStructure() {
        return this.infraStructure;
    }

    @Override
    public void setInfraStructure(INFRA_STRUCTURE infraStructure) {
        if (this.infraStructure != infraStructure) {
            INFRA_STRUCTURE oldInfraStructure = this.infraStructure;
            this.infraStructure = infraStructure;
            this.fireEvent((IEvent)new InfraStructureChangedEvent(oldInfraStructure, infraStructure));
        }
    }

    @Override
    public ILocationAware.Location getLocation() {
        return this.channel.getLocation();
    }

    @Override
    public boolean isClient() {
        return this.channel.isClient();
    }

    @Override
    public boolean isServer() {
        return this.channel.isServer();
    }

    @Override
    public IChannel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(IChannel newChannel) {
        if (this.channel != newChannel) {
            this.executorService = null;
            this.bufferProvider = null;
            if (this.channel != null) {
                this.channel.removeListener(this.channelListener);
            }
            this.channel = newChannel;
            if (this.channel != null) {
                this.channel.addListener(this.channelListener);
                this.executorService = ConcurrencyUtil.getExecutorService((Object)this.channel);
                this.bufferProvider = (InternalChannel)this.channel;
            }
        }
    }

    public String getUserID() {
        if (this.userID == null && this.channel != null) {
            return this.channel.getUserID();
        }
        return this.userID;
    }

    protected void setUserID(String userID) {
        this.userID = userID;
    }

    protected void handleChannelDeactivation() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.channel, "channel");
        this.checkState(this.bufferProvider, "bufferProvider");
        this.checkState(this.executorService, "executorService");
    }

    protected void doDeactivate() throws Exception {
        this.setChannel(null);
        super.doDeactivate();
    }

    public final class InfraStructureChangedEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final INFRA_STRUCTURE oldInfraStructure;
        private final INFRA_STRUCTURE newInfraStructure;

        private InfraStructureChangedEvent(INFRA_STRUCTURE oldInfraStructure, INFRA_STRUCTURE newInfraStructure) {
            super((INotifier)Protocol.this);
            this.oldInfraStructure = oldInfraStructure;
            this.newInfraStructure = newInfraStructure;
        }

        public Protocol<INFRA_STRUCTURE> getSource() {
            return Protocol.this;
        }

        public final INFRA_STRUCTURE getOldInfraStructure() {
            return this.oldInfraStructure;
        }

        public final INFRA_STRUCTURE getNewInfraStructure() {
            return this.newInfraStructure;
        }
    }
}

