/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;

public abstract class StandaloneCommand {
    private static final Logger logger = Logger.getLogger(StandaloneCommand.class);
    protected static @NonNull Appendable DEFAULT_OUTPUT_STREAM = System.out;
    protected final @NonNull StandaloneApplication standaloneApplication;
    protected final @NonNull String name;
    protected final @NonNull String help;
    protected final @NonNull Map<String, CommandToken> tokens = new HashMap<String, CommandToken>();

    public static @NonNull Appendable setDefaultOutputStream(@NonNull Appendable defaultOutputStream) {
        Appendable savedDefaultOutputStream = defaultOutputStream;
        DEFAULT_OUTPUT_STREAM = defaultOutputStream;
        return savedDefaultOutputStream;
    }

    protected StandaloneCommand(@NonNull StandaloneApplication standaloneApplication, @NonNull String name, @NonNull String help) {
        this.standaloneApplication = standaloneApplication;
        this.name = name;
        this.help = help;
    }

    protected void addToken(@NonNull CommandToken commandToken) {
        this.tokens.put(commandToken.getName(), commandToken);
    }

    public boolean analyze(@NonNull Map<@NonNull CommandToken, @NonNull List<@NonNull String>> token2strings) {
        for (CommandToken token : token2strings.keySet()) {
            List<String> strings;
            if (token.analyze(strings = token2strings.get(token))) continue;
            return false;
        }
        return true;
    }

    public abstract @NonNull StandaloneResponse execute() throws IOException;

    public @NonNull String getHelp() {
        return this.help;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Collection<@NonNull CommandToken> getTokens() {
        return this.tokens.values();
    }

    public @Nullable Map<@NonNull CommandToken, @NonNull List<@NonNull String>> parse(@NonNull String @NonNull [] arguments) {
        HashMap<@NonNull CommandToken, @NonNull List<@NonNull String>> parsedTokens = new HashMap<CommandToken, List<String>>();
        CommandToken nullToken = null;
        CommandToken currentToken = null;
        ArrayList<String> currentStrings = null;
        int i = 1;
        while (i < arguments.length) {
            int maxArguments;
            String argument;
            CommandToken token;
            if ((token = this.tokens.get(argument = arguments[i++])) != null) {
                currentToken = token;
                currentStrings = (ArrayList<String>)parsedTokens.get(currentToken);
                if (currentStrings == null) {
                    currentStrings = new ArrayList<String>();
                    parsedTokens.put(currentToken, currentStrings);
                    continue;
                }
                if (!currentToken.isSingleton()) continue;
                logger.error((Object)("Token '" + token.getName() + "' may only be used once"));
                return null;
            }
            if (currentToken != null && currentStrings != null && (maxArguments = currentToken.getMaxArguments()) >= 0 && currentStrings.size() >= maxArguments) {
                currentToken = null;
                currentStrings = null;
            }
            if (currentStrings == null) {
                if (nullToken == null) {
                    nullToken = new CommandToken(this.standaloneApplication, "", "", null){};
                }
                if ((currentStrings = (List)parsedTokens.get(nullToken)) == null) {
                    currentStrings = new ArrayList();
                    parsedTokens.put(nullToken, currentStrings);
                }
            }
            currentStrings.add(argument);
        }
        return parsedTokens;
    }

    public boolean parseCheck(@NonNull Map<@NonNull CommandToken, @NonNull List<@NonNull String>> token2strings) {
        HashSet<@NonNull CommandToken> validTokens = new HashSet<CommandToken>(this.tokens.values());
        for (CommandToken token : token2strings.keySet()) {
            List<@NonNull String> strings = token2strings.get(token);
            if (!validTokens.contains(token)) {
                logger.error((Object)("Misplaced arguments '" + strings + "'"));
                return false;
            }
            if (token.parseCheck(strings)) continue;
            return false;
        }
        for (CommandToken token : validTokens) {
            if (!token.isRequired() || token2strings.containsKey(token)) continue;
            logger.error((Object)("Missing token '" + token.getName() + "'"));
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    public static class BooleanToken
    extends CommandToken {
        private boolean isPresent = false;

        public BooleanToken(@NonNull StandaloneApplication standaloneApplication, @NonNull String name, @NonNull String commandHelp) {
            super(standaloneApplication, name, commandHelp, null);
        }

        @Override
        protected boolean analyze(@Nullable String string) {
            this.isPresent = true;
            return true;
        }

        @Override
        public int getMaxArguments() {
            return 0;
        }

        public boolean isPresent() {
            return this.isPresent;
        }
    }

    public static abstract class CommandToken {
        protected final @NonNull StandaloneApplication standaloneApplication;
        protected final @NonNull String name;
        protected final @NonNull String commandHelp;
        protected final @NonNull String argumentsHelp;
        protected boolean isRequired = false;

        protected CommandToken(@NonNull StandaloneApplication standaloneApplication, @NonNull String name, @NonNull String commandHelp, @Nullable String argumentsHelp) {
            this.standaloneApplication = standaloneApplication;
            this.name = name;
            this.commandHelp = commandHelp;
            this.argumentsHelp = argumentsHelp;
        }

        public final boolean analyze(@NonNull List<@NonNull String> strings) {
            if (strings.size() > 0) {
                for (String string : strings) {
                    if (this.analyze(string)) continue;
                    return false;
                }
            } else if (!this.analyze((String)null)) {
                return false;
            }
            return true;
        }

        protected boolean analyze(@Nullable String string) {
            return true;
        }

        public @Nullable String getArgumentsHelp() {
            return this.argumentsHelp;
        }

        public @NonNull String getCommandHelp() {
            return this.commandHelp;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int getMaxArguments() {
            return -1;
        }

        public int getMinArguments() {
            return 0;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean isSingleton() {
            return true;
        }

        public boolean parseCheck(@NonNull List<@NonNull String> strings) {
            int size = strings.size();
            if (size < this.getMinArguments()) {
                logger.error((Object)("Missing argument for '" + this.getName() + "'"));
                return false;
            }
            int maxArguments = this.getMaxArguments();
            if (maxArguments >= 0 && size > maxArguments) {
                logger.error((Object)("Too many '" + this.getName() + "' tokens"));
                return false;
            }
            for (String string : strings) {
                if (this.parseCheck(string)) continue;
                return false;
            }
            return true;
        }

        protected boolean parseCheck(@NonNull String string) {
            return true;
        }

        public void setIsRequired() {
            this.isRequired = true;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class OutputToken
    extends StringToken {
        private @Nullable File outputFile;

        public OutputToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-output", StandaloneMessages.StandaloneCommand_Output_Help, "<file-name>");
        }

        @Override
        public boolean analyze(@Nullable String string) {
            block6: {
                File file;
                block7: {
                    block5: {
                        try {
                            file = new File(string).getCanonicalFile();
                            if (!file.exists()) break block5;
                            if (file.isFile()) {
                                file.delete();
                                break block5;
                            }
                            logger.error((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OutputFile) + file.getAbsolutePath() + StandaloneMessages.OCLArgumentAnalyzer_NotFile));
                            return false;
                        }
                        catch (IOException e) {
                            logger.error((Object)e.getMessage());
                            return false;
                        }
                    }
                    if (file.exists()) break block6;
                    File outputFolder = file.getParentFile();
                    if (outputFolder.exists()) break block7;
                    logger.error((Object)(String.valueOf(StandaloneMessages.OCLArgumentAnalyzer_OutputDir) + outputFolder.getAbsolutePath() + StandaloneMessages.OCLArgumentAnalyzer_NotExist));
                    return false;
                }
                this.outputFile = file;
            }
            return true;
        }

        public File getOutputFile() {
            return this.outputFile;
        }
    }

    public static class StringToken
    extends CommandToken {
        public StringToken(@NonNull StandaloneApplication standaloneApplication, @NonNull String name, @NonNull String commandHelp, @Nullable String argumentsHelp) {
            super(standaloneApplication, name, commandHelp, argumentsHelp);
        }

        @Override
        public int getMaxArguments() {
            return 1;
        }

        @Override
        public int getMinArguments() {
            return 1;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }
    }
}

