/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.ids;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.ids.WildcardId;
import org.eclipse.ocl.pivot.internal.ids.BindingsIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedCollectionTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedLambdaTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedMapTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedTupleTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.NsURIPackageIdImpl;
import org.eclipse.ocl.pivot.internal.ids.ParametersIdImpl;
import org.eclipse.ocl.pivot.internal.ids.PrimitiveTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.RootPackageIdImpl;
import org.eclipse.ocl.pivot.internal.ids.TemplateParameterIdImpl;
import org.eclipse.ocl.pivot.internal.ids.TuplePartIdImpl;
import org.eclipse.ocl.pivot.internal.ids.UnspecifiedIdImpl;
import org.eclipse.ocl.pivot.internal.ids.WildcardIdImpl;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public final class IdManager {
    private static final @NonNull IdManager PRIVATE_INSTANCE = new IdManager();
    private static final @NonNull BindingsIdImpl.BindingsIdSingletonScope bindingsIds = new BindingsIdImpl.BindingsIdSingletonScope();
    private static final @NonNull GeneralizedCollectionTypeIdImpl.CollectionTypeIdSingletonScope collectionNames = new GeneralizedCollectionTypeIdImpl.CollectionTypeIdSingletonScope();
    private static final @NonNull GeneralizedMapTypeIdImpl.MapTypeIdSingletonScope mapNames = new GeneralizedMapTypeIdImpl.MapTypeIdSingletonScope();
    private static final @NonNull NsURIPackageIdImpl.NsURIPackageIdSingletonScope nsURIs = new NsURIPackageIdImpl.NsURIPackageIdSingletonScope();
    private static final @NonNull GeneralizedLambdaTypeIdImpl.LambdaTypeIdSingletonScope lambdaTypes = new GeneralizedLambdaTypeIdImpl.LambdaTypeIdSingletonScope();
    private static final @NonNull TuplePartIdImpl.TuplePartIdSingletonScope tupleParts = new TuplePartIdImpl.TuplePartIdSingletonScope();
    private static final @NonNull RootPackageIdImpl.RootPackageIdSingletonScope roots = new RootPackageIdImpl.RootPackageIdSingletonScope();
    private static final @NonNull List<@NonNull TemplateParameterIdImpl> templateParameterNormalizedIds = new ArrayList<TemplateParameterIdImpl>(10);
    private static final @NonNull GeneralizedTupleTypeIdImpl.TupleTypeIdSingletonScope tupleTypes = new GeneralizedTupleTypeIdImpl.TupleTypeIdSingletonScope();
    private static final @NonNull ParametersIdImpl.ParametersIdSingletonScope parametersIds = new ParametersIdImpl.ParametersIdSingletonScope();
    private static final @NonNull PrimitiveTypeIdImpl.PrimitiveTypeIdSingletonScope primitiveTypes = new PrimitiveTypeIdImpl.PrimitiveTypeIdSingletonScope();
    private static @Nullable Map<@NonNull String, @NonNull String> metamodelURI2name = null;
    private static @Nullable WildcardId wildcardId = null;
    public static final @NonNull RootPackageId METAMODEL = IdManager.getRootPackageId("$metamodel$");

    public static void addMetamodelEPackage(@NonNull String metamodelNsURI, @NonNull String metamodelName) {
        Map<@NonNull String, @NonNull String> metamodelURI2name2 = metamodelURI2name;
        if (metamodelURI2name2 == null) {
            metamodelURI2name = metamodelURI2name2 = new HashMap<String, String>();
        }
        metamodelURI2name2.put(metamodelNsURI, metamodelName);
    }

    public static @Nullable BindingsId basicGetBindingsId(@Nullable Iterable<@NonNull TemplateBinding> templateBindings) {
        if (templateBindings == null) {
            return null;
        }
        ArrayList<@NonNull TypeId> elementIdList = new ArrayList<TypeId>();
        for (TemplateBinding templateBinding : templateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : PivotUtil.getOwnedSubstitutions(templateBinding)) {
                Type actual = templateParameterSubstitution.getActual();
                elementIdList.add(actual.getTypeId());
            }
        }
        int size = elementIdList.size();
        if (size <= 0) {
            return null;
        }
        @NonNull ElementId[] elementIds = elementIdList.toArray(new ElementId[size]);
        return bindingsIds.getSingleton(PRIVATE_INSTANCE, elementIds, null);
    }

    public static @NonNull BindingsId getBindingsId(Type ... types) {
        @NonNull ElementId @NonNull [] elementIds = new ElementId[types.length];
        int i = 0;
        while (i < types.length) {
            elementIds[i] = types[i].getTypeId();
            ++i;
        }
        return IdManager.getBindingsId(elementIds);
    }

    public static @NonNull BindingsId getBindingsId(ElementId ... elementIds) {
        return bindingsIds.getSingleton(PRIVATE_INSTANCE, elementIds, null);
    }

    public static @NonNull BindingsId getBindingsId(Object ... elementIdAndValues) {
        int elementIdCount = 0;
        Object[] objectArray = elementIdAndValues;
        int n = elementIdAndValues.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Object elementId = objectArray[n2];
            if (elementId instanceof ElementId) {
                ++elementIdCount;
            }
            ++n2;
        }
        int valuesCount = elementIdAndValues.length - elementIdCount;
        @NonNull ElementId[] elementIds = new ElementId[elementIdCount];
        @NonNull Object[] values = new Object[valuesCount];
        int index = 0;
        int i = 0;
        while (i < elementIdCount) {
            elementIds[i] = (ElementId)elementIdAndValues[index++];
            ++i;
        }
        i = 0;
        while (i < valuesCount) {
            values[i] = elementIdAndValues[index++];
            ++i;
        }
        return bindingsIds.getSingleton(PRIVATE_INSTANCE, elementIds, values);
    }

    public static @NonNull BindingsId getBindingsId(@NonNull ElementId @NonNull [] elementIds, @NonNull Object @Nullable [] values) {
        return bindingsIds.getSingleton(PRIVATE_INSTANCE, elementIds, values);
    }

    public static @NonNull ClassId getClassId(@NonNull Class aType) {
        if (aType.eIsProxy()) {
            return IdManager.getUnspecifiedTypeId(aType);
        }
        Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(aType);
        String name = aType.getName();
        assert (name != null);
        Package parentPackage = unspecializedType.getOwningPackage();
        if (parentPackage != null) {
            TemplateParameters typeParameters = unspecializedType.getTypeParameters();
            PackageId packageId = parentPackage.getPackageId();
            ClassId unspecializedClassId = packageId.getClassId(name, typeParameters.parametersSize());
            BindingsId bindingsId = IdManager.basicGetBindingsId(PivotUtil.getOwnedBindings(aType));
            return bindingsId != null ? (ClassId)((Object)unspecializedClassId.getSpecializedId(bindingsId)) : unspecializedClassId;
        }
        return IdManager.getUnspecifiedTypeId(aType);
    }

    public static @NonNull ClassId getClassId(@NonNull EClass eClass) {
        EPackage ePackage = ClassUtil.nonNullEMF(eClass.getEPackage());
        PackageId packageId = IdManager.getPackageId(ePackage);
        String className = ClassUtil.nonNullEMF(NameUtil.getOriginalName((ENamedElement)eClass));
        ClassId classId = packageId.getClassId(className, eClass.getETypeParameters().size());
        return classId;
    }

    public static @NonNull CollectionTypeId getCollectionTypeId(@NonNull String collectionTypeName) {
        return collectionNames.getSingleton(PRIVATE_INSTANCE, collectionTypeName);
    }

    public static @NonNull DataTypeId getDataTypeId(@NonNull Class aType) {
        if (aType.eIsProxy()) {
            return IdManager.getUnspecifiedTypeId(aType);
        }
        Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(aType);
        String name = aType.getName();
        assert (name != null);
        Package parentPackage = unspecializedType.getOwningPackage();
        if (parentPackage != null) {
            TemplateParameters typeParameters = unspecializedType.getTypeParameters();
            PackageId packageId = parentPackage.getPackageId();
            DataTypeId unspecializedDataTypeId = packageId.getDataTypeId(name, typeParameters.parametersSize());
            BindingsId bindingsId = IdManager.basicGetBindingsId(PivotUtil.getOwnedBindings(aType));
            return bindingsId != null ? (DataTypeId)((Object)unspecializedDataTypeId.getSpecializedId(bindingsId)) : unspecializedDataTypeId;
        }
        return IdManager.getUnspecifiedTypeId(aType);
    }

    public static @NonNull EnumerationId getEnumerationId(@NonNull Enumeration anEnumeration) {
        String name = anEnumeration.getName();
        assert (name != null);
        Package parentPackage = anEnumeration.getOwningPackage();
        assert (parentPackage != null);
        return parentPackage.getPackageId().getEnumerationId(name);
    }

    @Deprecated
    public static @NonNull EnumerationId getEnumerationId(@NonNull EEnum eEnum) {
        String name = eEnum.getName();
        assert (name != null);
        EPackage parentPackage = eEnum.getEPackage();
        assert (parentPackage != null);
        return IdManager.getPackageId(parentPackage).getEnumerationId(name);
    }

    @Deprecated
    public static @NonNull EnumerationLiteralId getEnumerationLiteralId(@NonNull EEnumLiteral eEnumLiteral) {
        EEnum eEnum = ClassUtil.nonNullModel(eEnumLiteral.getEEnum());
        String name = ClassUtil.nonNullModel(eEnumLiteral.getName());
        EnumerationId enumerationId = IdManager.getEnumerationId(eEnum);
        EnumerationLiteralId enumerationLiteralId = enumerationId.getEnumerationLiteralId(name);
        return enumerationLiteralId;
    }

    public static @NonNull LambdaTypeId getLambdaTypeId(@NonNull LambdaType lambdaType) {
        String name = NameUtil.getSafeName(lambdaType);
        return IdManager.getLambdaTypeId(name, lambdaType.getParametersId());
    }

    public static @NonNull LambdaTypeId getLambdaTypeId(@NonNull String name, TypeId ... typeIds) {
        return IdManager.getLambdaTypeId(name, IdManager.getParametersId(typeIds));
    }

    public static @NonNull LambdaTypeId getLambdaTypeId(@NonNull String name, @NonNull ParametersId parametersId) {
        return lambdaTypes.getSingleton(PRIVATE_INSTANCE, name, parametersId);
    }

    public static @NonNull MapTypeId getMapTypeId(@NonNull String mapTypeName) {
        return mapNames.getSingleton(PRIVATE_INSTANCE, mapTypeName);
    }

    public static @NonNull NsURIPackageId getNsURIPackageId(@NonNull String nsURI, @Nullable String nsPrefix, @Nullable EPackage ePackage) {
        NsURIPackageId nsURIPackageId = nsURIs.getSingleton(PRIVATE_INSTANCE, nsURI, nsPrefix, ePackage);
        if (ePackage != null && nsURIPackageId.getEPackage() == null) {
            nsURIPackageId.setEPackage(ePackage);
        }
        return nsURIPackageId;
    }

    public static @NonNull OperationId getOperationId(@NonNull Operation anOperation) {
        ParametersId parametersId;
        String name = NameUtil.getSafeName(anOperation);
        Class owningClass = PivotUtil.getOwningClass(anOperation);
        TypeId parentTypeId = owningClass.getTypeId();
        TemplateParameters typeParameters = anOperation.getTypeParameters();
        int typeParametersSize = typeParameters.parametersSize();
        if (typeParametersSize <= 0 || anOperation.getUnspecializedElement() != null) {
            @NonNull Type @NonNull [] parameterTypes = TypeUtil.getOperationParameterTypes(anOperation);
            parametersId = IdManager.getParametersId(parameterTypes);
        } else {
            List<@NonNull TemplateParameter> contextTemplateParameters = PivotUtil.getTemplateParameters(owningClass);
            TemplateSignature operationTemplateSignature = anOperation.getOwnedSignature();
            if (operationTemplateSignature == null) {
                parametersId = ParametersId.EMPTY;
            } else {
                int operationTemplateParameterSize = Iterables.size(PivotUtil.getOwnedParameters(operationTemplateSignature));
                if (operationTemplateParameterSize <= 0) {
                    parametersId = ParametersId.EMPTY;
                } else {
                    @NonNull TypeId[] typeIds = new TypeId[operationTemplateParameterSize];
                    int contextTemplateParameterSize = contextTemplateParameters != null ? contextTemplateParameters.size() : 0;
                    int i = 0;
                    while (i < operationTemplateParameterSize) {
                        typeIds[i] = IdManager.getTemplateParameterId(contextTemplateParameterSize + i);
                        ++i;
                    }
                    parametersId = IdManager.getParametersId(typeIds);
                }
            }
        }
        return parentTypeId.getOperationId(typeParametersSize, name, parametersId);
    }

    public static @NonNull TupleTypeId getOrderedTupleTypeId(@NonNull String name, @NonNull TuplePartId @NonNull [] parts) {
        return tupleTypes.getSingleton(PRIVATE_INSTANCE, name, parts);
    }

    public static @NonNull PackageId getPackageId(@NonNull Package aPackage) {
        Package parentPackage;
        String nsURI = aPackage.getURI();
        if (nsURI != null) {
            return IdManager.getNsURIPackageId(nsURI, aPackage.getNsPrefix(), aPackage.getEPackage());
        }
        String name = aPackage.getName();
        if (name == null) {
            name = "";
        }
        if ((parentPackage = aPackage.getOwningPackage()) != null) {
            return parentPackage.getPackageId().getNestedPackageId(name);
        }
        return IdManager.getRootPackageId(name);
    }

    public static @NonNull PackageId getPackageId(@NonNull EPackage ePackage) {
        if (ClassUtil.basicGetMetamodelAnnotation(ePackage) != null) {
            return METAMODEL;
        }
        String nsURI = ePackage.getNsURI();
        if (nsURI != null) {
            EStructuralFeature eStructuralFeature;
            EClass eClass2;
            EObject eContainer2;
            EAnnotation eAnnotation;
            String metamodelName;
            if (metamodelURI2name != null && (metamodelName = metamodelURI2name.get(nsURI)) != null) {
                return IdManager.getRootPackageId(metamodelName);
            }
            EObject eContainer1 = ePackage.eContainer();
            if (eContainer1 instanceof EAnnotation && "http://www.eclipse.org/uml2/2.0.0/UML".equals((eAnnotation = (EAnnotation)eContainer1).getSource()) && (eContainer2 = eAnnotation.eContainer()) != null && "Profile".equals((eClass2 = eContainer2.eClass()).getName()) && (eStructuralFeature = eClass2.getEStructuralFeature("URI")) != null) {
                Object name;
                Object uri = eContainer2.eGet(eStructuralFeature);
                if (uri != null) {
                    return IdManager.getNsURIPackageId(String.valueOf(uri), ePackage.getNsPrefix(), ePackage);
                }
                eStructuralFeature = eClass2.getEStructuralFeature("name");
                if (eStructuralFeature != null && (name = eContainer2.eGet(eStructuralFeature)) != null) {
                    return IdManager.getRootPackageId(String.valueOf(name));
                }
            }
            return IdManager.getNsURIPackageId(nsURI, ePackage.getNsPrefix(), ePackage);
        }
        String name = ePackage.getName();
        assert (name != null);
        EPackage parentPackage = ePackage.getESuperPackage();
        if (parentPackage != null) {
            return IdManager.getPackageId(parentPackage).getNestedPackageId(name);
        }
        return IdManager.getNsURIPackageId(name, ePackage.getNsPrefix(), null);
    }

    public static @NonNull ParametersId getParametersId(@NonNull Type @NonNull [] parameterTypes) {
        int iSize = parameterTypes.length;
        @NonNull TypeId @NonNull [] typeIds = new TypeId[iSize];
        int i = 0;
        while (i < iSize) {
            Type parameterType = parameterTypes[i];
            boolean isNonNull = parameterType != null;
            typeIds[i] = isNonNull ? parameterType.getNormalizedTypeId() : TypeId.OCL_INVALID;
            ++i;
        }
        return IdManager.getParametersId(typeIds);
    }

    public static @NonNull ParametersId getParametersId(TypeId ... typeIds) {
        return parametersIds.getSingleton(PRIVATE_INSTANCE, typeIds);
    }

    public static @NonNull PrimitiveTypeId getPrimitiveTypeId(@NonNull String name) {
        return primitiveTypes.getSingleton(PRIVATE_INSTANCE, name);
    }

    public static @NonNull PropertyId getPropertyId(@NonNull EStructuralFeature eFeature) {
        String name = NameUtil.getOriginalName((ENamedElement)eFeature);
        assert (name != null);
        EClass parentClass = eFeature.getEContainingClass();
        assert (parentClass != null);
        ClassId classId = IdManager.getClassId(parentClass);
        return classId.getPropertyId(name);
    }

    public static @NonNull RootPackageId getRootPackageId(@NonNull String name) {
        return roots.getSingleton(PRIVATE_INSTANCE, name);
    }

    public static @NonNull TemplateParameterId getTemplateParameterIndexId(@NonNull TemplateParameter templateParameter) {
        List<@NonNull TemplateParameter> templateParameters = PivotUtil.getTemplateParameters(templateParameter);
        assert (templateParameters != null);
        int index = templateParameters.indexOf(templateParameter);
        return IdManager.getTemplateParameterId(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static @NonNull TemplateParameterId getTemplateParameterId(int index) {
        assert (index >= 0);
        if (index >= templateParameterNormalizedIds.size()) {
            List<TemplateParameterIdImpl> list = templateParameterNormalizedIds;
            synchronized (list) {
                while (index >= templateParameterNormalizedIds.size()) {
                    templateParameterNormalizedIds.add(new TemplateParameterIdImpl(PRIVATE_INSTANCE, templateParameterNormalizedIds.size()));
                }
            }
        }
        TemplateParameterIdImpl templateParameterId = templateParameterNormalizedIds.get(index);
        assert (templateParameterId != null);
        return templateParameterId;
    }

    public static @NonNull TuplePartId getTuplePartId(@NonNull Property asProperty) {
        TupleType tupleType = (TupleType)PivotUtil.getOwningClass(asProperty);
        String name = NameUtil.getSafeName(asProperty);
        int index = tupleType.getOwnedProperties().indexOf(asProperty);
        return IdManager.getTuplePartId(index, name, asProperty.getTypeId());
    }

    public static @NonNull TuplePartId getTuplePartId(int index, @NonNull String name, @NonNull TypeId typeId) {
        return tupleParts.getSingleton(PRIVATE_INSTANCE, index, name, typeId);
    }

    public static @NonNull TupleTypeId getTupleTypeId(@NonNull String name, @NonNull Collection<@NonNull ? extends TuplePartId> parts) {
        @NonNull Object @NonNull [] orderedParts = new TuplePartId[parts.size()];
        int i = 0;
        for (TuplePartId tuplePartId : parts) {
            orderedParts[i++] = tuplePartId;
        }
        Arrays.sort(orderedParts);
        return IdManager.getOrderedTupleTypeId(name, (TuplePartId[])orderedParts);
    }

    public static @NonNull TupleTypeId getTupleTypeId(@NonNull String name, TuplePartId ... parts) {
        @NonNull Object @NonNull [] orderedParts = new TuplePartId[parts.length];
        int i = 0;
        TuplePartId[] tuplePartIdArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId part = tuplePartIdArray[n2];
            orderedParts[i++] = part;
            ++n2;
        }
        Arrays.sort(orderedParts);
        return IdManager.getOrderedTupleTypeId(name, (TuplePartId[])orderedParts);
    }

    public static @NonNull TypeId getTypeId(@NonNull EClassifier eClassifier) {
        String name = NameUtil.getOriginalName((ENamedElement)eClassifier);
        assert (name != null);
        EPackage parentPackage = eClassifier.getEPackage();
        assert (parentPackage != null);
        EList eTypeParameters = eClassifier.getETypeParameters();
        assert (eTypeParameters != null);
        PackageId packageId = IdManager.getPackageId(parentPackage);
        int eTypeParameterCount = eTypeParameters.size();
        if (eClassifier instanceof EEnum) {
            return packageId.getEnumerationId(name);
        }
        if (eClassifier instanceof EDataType) {
            return packageId.getDataTypeId(name, eTypeParameterCount);
        }
        return packageId.getClassId(name, eTypeParameterCount);
    }

    public static @NonNull UnspecifiedIdImpl getUnspecifiedTypeId(@NonNull Type aType) {
        UnspecifiedIdImpl newId = new UnspecifiedIdImpl(PRIVATE_INSTANCE, aType);
        return newId;
    }

    public static @NonNull WildcardId getWildcardId() {
        WildcardId wildcardId2 = wildcardId;
        if (wildcardId2 == null) {
            wildcardId = wildcardId2 = new WildcardIdImpl(PRIVATE_INSTANCE);
        }
        return wildcardId2;
    }

    private IdManager() {
    }
}

