/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.NestedPackageId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.internal.ids.AbstractPackageIdImpl;

public class NestedPackageIdImpl
extends AbstractPackageIdImpl
implements NestedPackageId {
    protected final @NonNull PackageId parent;
    protected final @NonNull String name;

    private static int computeHashCode(@NonNull ElementId parentId, @NonNull String name) {
        return IdHash.createChildHash(parentId, name);
    }

    public NestedPackageIdImpl(@NonNull PackageId parent, @NonNull String name) {
        super(NestedPackageIdImpl.computeHashCode(parent, name));
        this.parent = parent;
        this.name = name;
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitNestedPackageId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        if (this.parent instanceof NsURIPackageId) {
            return this.name;
        }
        return this.parent + "::" + this.name;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull PackageId getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        return this.parent + "::" + this.name;
    }

    public static class NestedPackageIdSingletonScope
    extends AbstractSingletonScope<NestedPackageId, String> {
        public @NonNull NestedPackageId getSingleton(@NonNull PackageId parentId, @NonNull String value) {
            return this.getSingletonFor(new NestedPackageIdValue(parentId, value));
        }
    }

    private static class NestedPackageIdValue
    extends SingletonScope.AbstractKeyAndValue<NestedPackageId> {
        private final @NonNull PackageId parentId;
        private final @NonNull String value;

        private NestedPackageIdValue(@NonNull PackageId parentId, @NonNull String value) {
            super(NestedPackageIdImpl.computeHashCode(parentId, value));
            this.parentId = parentId;
            this.value = value;
        }

        @Override
        public @NonNull NestedPackageId createSingleton() {
            return new NestedPackageIdImpl(this.parentId, this.value);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof NestedPackageIdImpl) {
                NestedPackageIdImpl singleton = (NestedPackageIdImpl)that;
                return singleton.getName().equals(this.value);
            }
            return false;
        }
    }
}

