/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.validation;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.annotations.PivotAnnotationsPackage;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.validation.BasicEAnnotationValidator2;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;

public final class OCL_Import_AnnotationValidator
extends BasicEAnnotationValidator2 {
    public static final @NonNull OCL_Import_AnnotationValidator INSTANCE = new OCL_Import_AnnotationValidator();
    public static final @NonNull String ANNOTATION_NAME = "OCL_Import";
    public static final @NonNull String ANNOTATION_SOURCE = "http://www.eclipse.org/OCL/Import";
    public static final @NonNull String DIAGNOSTIC_SOURCE = "org.eclipse.ocl.pivot.annotation";

    public OCL_Import_AnnotationValidator() {
        super(ANNOTATION_SOURCE, ANNOTATION_NAME, DIAGNOSTIC_SOURCE, PivotAnnotationsPackage.Literals.IMPORT_EPACKAGE);
    }

    protected BasicEAnnotationValidator.Assistant createAssistant() {
        return new BasicEAnnotationValidator2.MapAssistant(this, PivotAnnotationsPackage.Literals.IMPORT_EPACKAGE.getName()){

            @Override
            protected @NonNull EStructuralFeature createEStructuralFeature(String key) {
                EAttribute eStructuralFeature = EcoreFactory.eINSTANCE.createEAttribute();
                eStructuralFeature.setName(String.valueOf(key));
                eStructuralFeature.setEType((EClassifier)EcorePackage.Literals.ESTRING);
                return eStructuralFeature;
            }
        };
    }

    @Override
    protected Map<String, EStructuralFeature> getProperties(EModelElement eModelElement) {
        return this.getNoFeatureProperties(eModelElement);
    }

    protected boolean validateDetail(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String importURI = entry.getValue();
        if (importURI != null) {
            URI uri2;
            Resource eResource;
            EPackage.Registry packageRegistry;
            EPackage registeredPackage;
            ResourceSet resourceSet = null;
            EnvironmentFactoryInternal environmentFactory = ThreadLocalExecutor.basicGetEnvironmentFactory();
            if (environmentFactory != null) {
                resourceSet = environmentFactory.getResourceSet();
            }
            if ((registeredPackage = (packageRegistry = resourceSet != null ? resourceSet.getPackageRegistry() : EPackage.Registry.INSTANCE).getEPackage(importURI)) != null) {
                return true;
            }
            URIConverter uriConverter = resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
            URI uri = URI.createURI((String)importURI);
            if (eModelElement != null && (eResource = eModelElement.eResource()) != null && (uri2 = eResource.getURI()) != null && !uri2.isRelative()) {
                uri = uri.resolve(uri2);
            }
            if (uriConverter.exists(uri.trimFragment(), null)) {
                return true;
            }
        }
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, 0, this.getEcoreResourceLocator().getString("_UI_GenericConstraint_diagnostic", new Object[]{"ResolveableURI", importURI}), new Object[0]));
        }
        return false;
    }
}

