/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.AbstractFeature;
import org.eclipse.ocl.pivot.library.LibraryIterationOrOperation;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public abstract class AbstractIterationOrOperation
extends AbstractFeature
implements LibraryIterationOrOperation {
    protected @Nullable Type resolveCollectionAsCollectionReturnType(@NonNull EnvironmentFactory environmentFactory, @NonNull CallExp callExp, @Nullable Type returnType) {
        OCLExpression ownedSource;
        if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null) {
            Type sourceType = ownedSource.getType();
            CollectionType returnCollectionType = (CollectionType)returnType;
            if (sourceType instanceof CollectionType) {
                CollectionType sourceCollectionType = (CollectionType)sourceType;
                Type elementType = PivotUtil.getElementType(sourceCollectionType);
                PivotMetamodelManager metamodelManager = (PivotMetamodelManager)environmentFactory.getMetamodelManager();
                returnType = metamodelManager.getCollectionType(returnCollectionType.isOrdered(), returnCollectionType.isUnique(), elementType, sourceCollectionType.isIsNullFree(), sourceCollectionType.getLowerValue(), sourceCollectionType.getUpperValue());
            }
        }
        return returnType;
    }

    protected boolean resolveCollectionSourceElementReturnNullity(@NonNull EnvironmentFactory environmentFactory, @NonNull CallExp callExp, boolean returnIsRequired) {
        Type sourceType;
        OCLExpression ownedSource = callExp.getOwnedSource();
        if (ownedSource != null && (sourceType = ownedSource.getType()) instanceof CollectionType) {
            returnIsRequired = ((CollectionType)sourceType).isIsNullFree();
        }
        return returnIsRequired;
    }

    protected @Nullable Type resolveCollectionSourceReturnType(@NonNull EnvironmentFactory environmentFactory, @NonNull CallExp callExp, @Nullable Type returnType) {
        OCLExpression ownedSource;
        if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null) {
            Type sourceType = ownedSource.getType();
            CollectionType collectionType = (CollectionType)returnType;
            if (sourceType instanceof CollectionType && ((CollectionType)sourceType).isIsNullFree() && !collectionType.isIsNullFree()) {
                @NonNull Type elementType = collectionType.getElementType();
                PivotMetamodelManager metamodelManager = (PivotMetamodelManager)environmentFactory.getMetamodelManager();
                returnType = metamodelManager.getCollectionType(collectionType.isOrdered(), collectionType.isUnique(), elementType, true, collectionType.getLowerValue(), collectionType.getUpperValue());
            }
        }
        return returnType;
    }
}

