/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.builder;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.xtext.base.ui.BaseUIActivator;
import org.eclipse.ocl.xtext.base.ui.builder.AbstractBuildSelector;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;

public abstract class AbstractValidatingBuilder
extends IncrementalProjectBuilder {
    public static final @NonNull TracingOption BUILDER = new TracingOption("org.eclipse.ocl.xtext.base.ui", "builder");

    static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf((char)'/', (char[])pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf((char)'*', (char[])pattern, (int)lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray((char[])pattern, (int)0, (int)lastSlash);
                    }
                    if (!CharOperation.pathMatch((char[])folderPattern, (char[])path, (boolean)true, (char)'/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat((char[])path, (char[])new char[]{'*'}, (char)'/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (BUILDER.isActive()) {
            BUILDER.println(String.valueOf(this.getDebugName()) + " build " + this.getKindAsString(kind));
        }
        long startTime = System.currentTimeMillis();
        int selectionSize = -1;
        int unselectionSize = -1;
        IProject project = this.getProject();
        assert (project != null);
        String builderName = this.getBuilderName();
        String projectName = project.getName();
        try {
            IResourceDelta delta;
            AbstractBuildSelector buildSelector;
            String initializingMessage = StringUtil.bind((String)BaseUIMessages.MultiValidationJob_Initializing, (Object[])new Object[]{builderName, projectName});
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)initializingMessage, (int)3);
            if (kind == 6) {
                this.getProject().deleteMarkers(this.getMarkerId(), true, 2);
                buildSelector = this.createBuildSelector(project, BuildType.FULL, args, (IProgressMonitor)subMonitor);
                delta = null;
            } else if (kind == 9) {
                delta = this.getDelta(this.getProject());
                buildSelector = this.createBuildSelector(project, BuildType.INCREMENTAL, args, (IProgressMonitor)subMonitor);
            } else {
                if (kind == 10) {
                    return null;
                }
                return null;
            }
            try {
                subMonitor.worked(1);
                String selectingMessage = StringUtil.bind((String)BaseUIMessages.MultiValidationJob_Selecting, (Object[])new Object[]{builderName, projectName});
                subMonitor.subTask(selectingMessage);
                selectionSize = buildSelector.selectResources(delta);
                unselectionSize = buildSelector.deleteRemovedResourceMarkers();
                subMonitor.worked(1);
                if (selectionSize > 0) {
                    String queueingMessage = StringUtil.bind((String)BaseUIMessages.MultiValidationJob_Queuing, (Object[])new Object[]{builderName, selectionSize, projectName});
                    subMonitor.subTask(queueingMessage);
                    buildSelector.buildResources();
                    subMonitor.worked(1);
                }
                subMonitor.done();
            }
            catch (CoreException e) {
                this.getLog().error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (OperationCanceledException e) {
                this.handleCanceled(e);
            }
            catch (Exception e) {
                this.getLog().error((Object)e.getMessage(), (Throwable)e);
                this.forgetLastBuiltState();
            }
        }
        finally {
            if (BUILDER.isActive()) {
                long endTime = System.currentTimeMillis();
                BUILDER.println(String.valueOf(endTime - startTime) + " ms to select/unselect " + selectionSize + "/" + unselectionSize + " elements on \"" + Thread.currentThread().getName() + "\"");
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (BUILDER.isActive()) {
            BUILDER.println(String.valueOf(this.getDebugName()) + " clean");
        }
        BaseUIActivator.cancelMultiValidationJob();
        this.getProject().deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 2);
    }

    protected abstract @NonNull AbstractBuildSelector createBuildSelector(@NonNull IProject var1, @NonNull BuildType var2, @Nullable Map<String, String> var3, @NonNull IProgressMonitor var4);

    protected abstract @NonNull String getBuilderName();

    protected String getDebugName() {
        String name = ((Object)((Object)this)).getClass().getName();
        int lastIndex = name.lastIndexOf(".");
        return String.valueOf(lastIndex >= 0 ? name.substring(lastIndex + 1) : name) + "-" + this.getBuildConfig();
    }

    private String getKindAsString(int kind) {
        switch (kind) {
            case 9: {
                return "AUTO_BUILD";
            }
            case 15: {
                return "CLEAN_BUILD";
            }
            case 6: {
                return "FULL_BUILD";
            }
            case 10: {
                return "INCREMENTAL_BUILD";
            }
        }
        return "OTHER_BUILD";
    }

    protected abstract Logger getLog();

    protected @NonNull String getMarkerId() {
        return "org.eclipse.ocl.xtext.base.ui.Marker";
    }

    private void handleCanceled(Throwable t) {
        BaseUIActivator.cancelMultiValidationJob();
    }

    protected static enum BuildType {
        CLEAN,
        FULL,
        INCREMENTAL,
        RECOVERY;

    }
}

