/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMFUtil {
    public static boolean isInFirstResource(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return false;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        EList resources = resourceSet.getResources();
        return resources.size() > 0 && resourceSet.getResources().get(0) == resource;
    }

    public Collection<EObject> findInstancesOf(EClass eClass, Resource resource) {
        ArrayList<EObject> instances = new ArrayList<EObject>();
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (eObject.eClass() != eClass) continue;
            instances.add(eObject);
        }
        return instances;
    }

    private static void addAll(Set<EClass> classes, List<Resource> resources) {
        for (Resource resource : resources) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof EClass)) continue;
                EClass eClass = (EClass)eObject;
                classes.add(eClass);
            }
        }
    }

    public static EClass findCommonClass(List<EObject> elements) {
        EClass eClass = null;
        for (EObject element : elements) {
            EClass elementEClass = element.eClass();
            if (eClass == null) {
                eClass = elementEClass;
                continue;
            }
            if (eClass.isSuperTypeOf(elementEClass)) continue;
            if (elementEClass.isSuperTypeOf(eClass)) {
                eClass = elementEClass;
                continue;
            }
            if ((eClass = EMFUtil.findSuperType(eClass, elementEClass)) != null) continue;
            return null;
        }
        return eClass;
    }

    private static EClass findSuperType(EClass eClass, EClass element) {
        LinkedList<EClass> breadthFirstList = new LinkedList<EClass>();
        breadthFirstList.addFirst(eClass);
        while (!breadthFirstList.isEmpty()) {
            EClass candidateClass = (EClass)breadthFirstList.poll();
            if (candidateClass.isSuperTypeOf(element)) {
                return candidateClass;
            }
            for (EClass supertype : candidateClass.getESuperTypes()) {
                breadthFirstList.addLast(supertype);
            }
        }
        return null;
    }

    public static boolean tryResolve(EObject eObject) {
        EObject resolved = EcoreUtil.resolve((EObject)eObject, null);
        return !resolved.eIsProxy();
    }

    public static String proxyURI(EObject eObject) {
        URI eProxyURI = ((InternalEObject)eObject).eProxyURI();
        if (eProxyURI == null) {
            return "";
        }
        return eProxyURI.toString();
    }

    public static <T extends ENamedElement> T findElementWithName(String name, EList<T> elements) {
        for (ENamedElement element : elements) {
            if (!name.equals(element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    public static String getMetamodelName(String nsURI) {
        if (nsURI != null) {
            String name;
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            if (ePackage != null && (name = ePackage.getName()) != null) {
                return name;
            }
            URI uri = URI.createURI((String)nsURI);
            String lastSegment = uri.lastSegment();
            if (lastSegment != null) {
                return lastSegment;
            }
        }
        return null;
    }

    public static List<EClass> getMetaclasses(Resource metamodel) {
        ArrayList<EClass> metaclasses = new ArrayList<EClass>();
        TreeIterator allContents = metamodel.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof EClass)) continue;
            EClass eClass = (EClass)eObject;
            metaclasses.add(eClass);
        }
        return metaclasses;
    }

    public static EObject findElementByURI(String uriFragment, ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            EObject eObject = resource.getEObject(uriFragment);
            if (eObject == null) continue;
            return eObject;
        }
        return null;
    }
}

