/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.sdk.core.internal;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.sdk.core.ICustomizationActions;
import org.eclipse.papyrus.emf.facet.custom.sdk.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.emf.core.ICatalogSetManager2;
import org.eclipse.papyrus.emf.facet.util.emf.core.ICatalogSetManagerFactory;
import org.eclipse.papyrus.emf.facet.util.emf.core.exception.InvalidFacetSetException;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.exported.BuildPropertiesUtils;

public class CustomizationActionsImpl
implements ICustomizationActions {
    @Override
    public void saveCustomization(Customization customization, IFile file) throws IOException, InvalidFacetSetException {
        if (customization == null) {
            throw new IllegalArgumentException("The given customization cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("The given file cannot be null");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("The given file already exists");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)customization);
        resource.save(null);
        try {
            BuildPropertiesUtils.addToBuild((IFile)file);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)("Error adding file " + String.valueOf(file.getFullPath()) + " to the build.properties"), (Plugin)Activator.getDefault());
        }
        ICatalogSetManager2 catalogSetManager = ICatalogSetManagerFactory.DEFAULT.createICatalogSetManager((ResourceSet)resourceSet);
        catalogSetManager.registerModelDeclaration(file);
    }
}

