/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.emf.facet.efacet.core.FacetUtils;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

public class FacetSetTreeContentProvider
implements ITreeContentProvider {
    private final boolean bFacets;
    private final boolean bContainedFS;
    private final boolean bSubpackages;

    public FacetSetTreeContentProvider(boolean facets, boolean containedFSs, boolean subpackages) {
        this.bFacets = facets;
        this.bContainedFS = containedFSs;
        this.bSubpackages = subpackages;
    }

    public FacetSetTreeContentProvider() {
        this(true, true, true);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == null) {
            throw new IllegalArgumentException("inputElement must not be null");
        }
        if (!(inputElement instanceof Object[])) {
            throw new IllegalArgumentException("inputElement must be an array");
        }
        return (Object[])inputElement;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList children = new ArrayList();
        if (parentElement instanceof FacetSet) {
            FacetSet facetSet = (FacetSet)parentElement;
            if (this.bContainedFS) {
                children.addAll(facetSet.getFacetSets());
            }
            if (this.bFacets) {
                children.addAll(FacetUtils.getFacets((FacetSet)facetSet));
            }
            if (this.bSubpackages) {
                children.addAll(facetSet.getESubpackages());
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        FacetSet parent = null;
        if (element instanceof Facet) {
            Facet facet = (Facet)element;
            parent = FacetUtils.getFacetSet((Facet)facet);
        } else if (element instanceof EPackage) {
            EPackage ePackage = (EPackage)element;
            parent = ePackage.getESuperPackage();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }
}

