/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.IServiceRegistryProvider;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.tools.util.IProgressRunnable;

@FunctionalInterface
public interface IPapyrusRunnable
extends IProgressRunnable,
IServiceRegistryProvider {
    @Override
    default public ServicesRegistry getServiceRegistry() {
        try {
            return ServiceUtils.getInstance().getServiceRegistry(null);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static IPapyrusRunnable inContext(final ServicesRegistry registry, final IPapyrusRunnable runnable) {
        return new IPapyrusRunnable(){

            public void run(IProgressMonitor monitor) {
                runnable.run(monitor);
            }

            @Override
            public ServicesRegistry getServiceRegistry() {
                return registry;
            }
        };
    }
}

