/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class OneShotExecutor
implements Executor {
    private final AtomicReference<Runnable> pending = new AtomicReference();
    private final Executor delegate;

    public OneShotExecutor(Executor executor) {
        this.delegate = executor;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(new Task(command));
    }

    private final class Task
    implements Runnable {
        private final Runnable delegate;

        Task(Runnable command) {
            this.delegate = command;
            OneShotExecutor.this.pending.set(this);
        }

        @Override
        public void run() {
            if (OneShotExecutor.this.pending.compareAndSet(this, null)) {
                this.delegate.run();
            }
        }
    }
}

