/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.widgets;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.editor.welcome.nattable.ServiceConfigAttributes;
import org.eclipse.papyrus.infra.editor.welcome.nattable.painter.LabelPainter;
import org.eclipse.papyrus.infra.editor.welcome.nattable.painter.LabelProviderImagePainter;
import org.eclipse.papyrus.infra.editor.welcome.nattable.painter.LabelProviderTextPainter;
import org.eclipse.papyrus.infra.editor.welcome.nattable.sorting.ColumnHeaderHelper;
import org.eclipse.papyrus.infra.editor.welcome.nattable.sorting.EventListObservableAdapter;
import org.eclipse.papyrus.infra.editor.welcome.nattable.sorting.PapyrusGlazedListEventsLayer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class FormTable<E>
extends Composite {
    private final IConfigRegistry configRegistry;
    private final NatTable table;
    private final EventListObservableAdapter<E> backingList;
    private final PapyrusGlazedListEventsLayer<E> eventLayer;
    private String propertyPath;
    private DataSource input;

    public FormTable(Composite parent, int style, IColumnPropertyAccessor<E> columnAccessor, String ... columnTitle) {
        this(parent, style, false, null, columnAccessor, columnTitle);
    }

    public FormTable(Composite parent, int style, boolean filter, IColumnPropertyAccessor<E> columnAccessor, String ... columnTitle) {
        this(parent, style, filter, null, columnAccessor, columnTitle);
    }

    public FormTable(Composite parent, int style, String label, IColumnPropertyAccessor<E> columnAccessor, String ... columnTitle) {
        this(parent, style, false, label, columnAccessor, columnTitle);
    }

    public FormTable(Composite parent, int style, boolean filter, String label, IColumnPropertyAccessor<E> columnAccessor, String ... columnTitle) {
        super(parent, style);
        SortedList sortedList;
        this.setBackground(parent.getBackground());
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayout());
        this.configRegistry = new ConfigRegistry();
        if (label != null && !label.isEmpty()) {
            Label _label = new Label(parent, 16384);
            _label.setText(label);
        }
        Text filterField = null;
        if (filter) {
            filterField = new Text(parent, 2432);
            filterField.setMessage("filter");
            filterField.setToolTipText("Filter the table contents (use * to match any string)");
            GridDataFactory.fillDefaults().applyTo((Control)filterField);
        }
        this.backingList = new EventListObservableAdapter();
        FilterList filteredList = null;
        if (filter) {
            filteredList = new FilterList(this.backingList);
            sortedList = new SortedList((EventList)filteredList, null);
        } else {
            sortedList = new SortedList(this.backingList, null);
        }
        ListDataProvider dataProvider = new ListDataProvider((List)sortedList, columnAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)dataProvider);
        this.eventLayer = new PapyrusGlazedListEventsLayer<E>((IUniqueIndexLayer)bodyDataLayer, this.backingList);
        SelectionLayer selectionLayer = new SelectionLayer(this.eventLayer, false);
        this.addConfigurations(selectionLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        ColumnHeaderHelper<E> headerHelper = new ColumnHeaderHelper<E>(this.configRegistry, (ILayer)viewportLayer, selectionLayer);
        FilterRowHeaderComposite headers = headerHelper.createHeaderLayer(sortedList, columnAccessor, columnTitle);
        if (filteredList != null) {
            headers = headerHelper.createFilterLayer(filteredList);
            headerHelper.setFilterField(filterField);
        }
        CompositeLayer composition = new CompositeLayer(1, 2);
        composition.setChildLayer("COLUMN_HEADER", headers, 0, 0);
        composition.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        headerHelper.configureSorting();
        LabelProviderTextPainter commonPainter = new LabelProviderTextPainter(false, true, 3, true);
        LabelPainter iconAndTextPainter = new LabelPainter((ICellPainter)commonPainter, CellEdgeEnum.LEFT, (ICellPainter)new LabelProviderImagePainter());
        Style headerStyle = new Style();
        headerStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)parent.getBackground());
        headerStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
        headerStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        headerHelper.configureHeaders((ICellPainter)commonPainter, (IStyle)headerStyle);
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)iconAndTextPainter, "NORMAL", "BODY");
        Style bodyStyle = new Style();
        bodyStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)parent.getBackground());
        bodyStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
        this.configureBodyStyle(bodyStyle);
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)bodyStyle, "NORMAL", "BODY");
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, (Object)false);
        this.table = new NatTable(parent, (ILayer)composition, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setConfigRegistry(this.configRegistry);
        this.table.setBackground(parent.getBackground());
        this.table.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.table.configure();
    }

    protected void addConfigurations(SelectionLayer selectionLayer) {
    }

    protected void configureBodyStyle(Style bodyStyle) {
    }

    public void setProperty(String propertyPath) {
        this.propertyPath = propertyPath;
        this.checkInput();
    }

    public String getProperty() {
        return this.propertyPath;
    }

    public void setInput(DataSource input) {
        this.input = input;
        this.checkInput();
    }

    protected void checkInput() {
        String propertyPath = this.getProperty();
        if (this.input != null && propertyPath != null) {
            String elementPath = propertyPath.substring(0, propertyPath.lastIndexOf(58));
            String propertyName = propertyPath.substring(elementPath.length() + 1);
            ModelElement element = this.input.getModelElement(elementPath);
            ServiceConfigAttributes.with(this.configRegistry, this::getService).register(LabelProviderService.class).register(NavigationService.class).register(IPageManager.class);
            ServiceConfigAttributes.registerService(ISelectionProvider.class, this.configRegistry, this.getService(IMultiDiagramEditor.class).getEditorSite().getSelectionProvider());
            this.eventLayer.setActive(false);
            try {
                IObservableList diagrams = (IObservableList)element.getObservable(propertyName);
                this.backingList.setDelegate(diagrams);
            }
            finally {
                this.eventLayer.setActive(true);
                this.table.refresh();
            }
        }
    }

    public DataSource getInput() {
        return this.input;
    }

    protected EObject getModelElement() {
        return EMFHelper.getEObject((Object)this.input.getSelection().getFirstElement());
    }

    protected <S> S getService(Class<? extends S> serviceType) {
        try {
            return (S)ServiceUtilsForEObject.getInstance().getService(serviceType, (Object)this.getModelElement());
        }
        catch (ServiceException e) {
            throw new IllegalStateException(e);
        }
    }
}

