/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomDoubleStyleObservableValue;

public class CustomDoubleStyleWithStoreObservableValue
extends CustomDoubleStyleObservableValue {
    protected IPreferenceStore preferenceStore;
    protected IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent event) {
            if (CustomDoubleStyleWithStoreObservableValue.this.styleName.equals(event.getProperty())) {
                ValueDiff diff = new ValueDiff(){

                    public Object getOldValue() {
                        return event.getOldValue();
                    }

                    public Object getNewValue() {
                        return event.getNewValue();
                    }
                };
                CustomDoubleStyleWithStoreObservableValue.this.fireValueChange(diff);
            }
        }
    };

    public CustomDoubleStyleWithStoreObservableValue(View source, EditingDomain domain, String styleName, IPreferenceStore preferenceStore) {
        super(source, domain, styleName);
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener(this.listener);
    }

    @Override
    public void handleChange(ChangeEvent event) {
        super.handleChange(event);
        this.addToPreferenceStore(this.doGetValue());
    }

    public void addToPreferenceStore(final Object value) {
        if (value instanceof Float) {
            final double oldValue = (Double)this.doGetValue();
            this.preferenceStore.setValue(this.styleName, ((Float)value).doubleValue());
            ValueDiff diff = new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return ((Float)value).doubleValue();
                }
            };
            this.fireValueChange(diff);
        } else if (value instanceof Double) {
            final double oldValue = (Double)this.doGetValue();
            this.preferenceStore.setValue(this.styleName, ((Double)value).doubleValue());
            ValueDiff diff = new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return (double)((Double)value);
                }
            };
            this.fireValueChange(diff);
        }
    }

    @Override
    public void dispose() {
        this.preferenceStore.removePropertyChangeListener(this.listener);
        super.dispose();
    }

    @Override
    protected Object getDefaultValue() {
        return this.preferenceStore.getDouble(this.styleName);
    }
}

