/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.LineStyleEnum;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.NamedStyleProperties;

public abstract class PapyrusRoundedEditPartHelper
implements NamedStyleProperties {
    public static void refreshBorderStyle(IPapyrusEditPart editpart, int defaultBorderStyle, int[] defaultLineCustomValue) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            int borderStyle = PapyrusRoundedEditPartHelper.getNotationBorderStyle(editpart, defaultBorderStyle);
            roundedRectangleFigure.setBorderStyle(borderStyle);
            int[] customDash = NotationUtils.getIntListValue((View)((GraphicalEditPart)editpart).getModel(), "customDash", defaultLineCustomValue);
            roundedRectangleFigure.setCustomDash(customDash);
        }
    }

    public static int getNotationBorderStyle(IPapyrusEditPart editpart, int defaultBorderStyle) {
        String str;
        LineStyleEnum lineStyle;
        NamedStyle borderValueStyle;
        EClass stringValueStyle = NotationPackage.eINSTANCE.getStringValueStyle();
        int borderStyle = defaultBorderStyle;
        if (stringValueStyle != null && ((GraphicalEditPart)editpart).getModel() instanceof View && (borderValueStyle = ((View)((GraphicalEditPart)editpart).getModel()).getNamedStyle(stringValueStyle, "borderStyle")) instanceof StringValueStyle && (lineStyle = LineStyleEnum.getByLiteral(str = ((StringValueStyle)borderValueStyle).getStringValue())) != null) {
            borderStyle = lineStyle.getLineStyle();
        }
        return borderStyle;
    }

    public static void refreshFloatingName(IPapyrusEditPart editpart, boolean defaultIsFloatingNameConstrained, int defaultFloatingLabelOffsetWidth, int defaultFloatingLabelOffsetHeight) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            if (((GraphicalEditPart)editpart).getModel() instanceof View) {
                boolean isNameConstrained = NotationUtils.getBooleanValue((View)((GraphicalEditPart)editpart).getModel(), "isFloatingLabelConstrained", defaultIsFloatingNameConstrained);
                int width = NotationUtils.getIntValue((View)((GraphicalEditPart)editpart).getModel(), "floatingLabelOffsetWidth", defaultFloatingLabelOffsetWidth);
                int height = NotationUtils.getIntValue((View)((GraphicalEditPart)editpart).getModel(), "floatingLabelOffsetHeight", defaultFloatingLabelOffsetHeight);
                roundedRectangleFigure.setFloatingNameConstrained(isNameConstrained);
                roundedRectangleFigure.setFloatingNameOffset(new Dimension(width, height));
            }
        }
    }

    public static void refreshOval(IPapyrusEditPart editpart, boolean defaultIsOvalValue) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure && ((GraphicalEditPart)editpart).getModel() instanceof View) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            boolean isOval = NotationUtils.getBooleanValue((View)((GraphicalEditPart)editpart).getModel(), "isOval", defaultIsOvalValue);
            roundedRectangleFigure.setOval(isOval);
        }
    }

    public static void refreshPackage(IPapyrusEditPart editpart, boolean defaultIsPackageValue) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure && ((GraphicalEditPart)editpart).getModel() instanceof View) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            boolean isPackage = NotationUtils.getBooleanValue((View)((GraphicalEditPart)editpart).getModel(), "isPackage", defaultIsPackageValue);
            roundedRectangleFigure.setIsPackage(isPackage);
        }
    }

    public static void refreshShadowWidth(IPapyrusEditPart editpart, int defaultShadowWidthValue) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure && ((GraphicalEditPart)editpart).getModel() instanceof View) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            int shadowWidth = NotationUtils.getIntValue((View)((GraphicalEditPart)editpart).getModel(), "shadowWidth", defaultShadowWidthValue);
            roundedRectangleFigure.setShadowWidth(shadowWidth >= 0 ? shadowWidth : defaultShadowWidthValue);
        }
    }

    public static void refreshRadius(IPapyrusEditPart editpart, int defaultCornerWidth, int defaultCornerHeight) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            if (((GraphicalEditPart)editpart).getModel() instanceof View) {
                int width = NotationUtils.getIntValue((View)((GraphicalEditPart)editpart).getModel(), "radiusWidth", defaultCornerWidth);
                int height = NotationUtils.getIntValue((View)((GraphicalEditPart)editpart).getModel(), "radiusHeight", defaultCornerHeight);
                roundedRectangleFigure.setCornerDimensions(new Dimension(width, height));
            }
        }
    }

    public static void refreshHasHeader(IPapyrusEditPart editpart, boolean defaultHasHeader) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure && ((GraphicalEditPart)editpart).getModel() instanceof View) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            boolean hasHeader = NotationUtils.getBooleanValue((View)((GraphicalEditPart)editpart).getModel(), "displayHeader", defaultHasHeader);
            roundedRectangleFigure.setHasHeader(hasHeader);
        }
    }

    public static void refreshShadowColor(IPapyrusEditPart editpart, String defaultShadowColor) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure && ((GraphicalEditPart)editpart).getModel() instanceof View) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            String shadowColor = NotationUtils.getStringValue((View)((GraphicalEditPart)editpart).getModel(), "shadowColor", defaultShadowColor);
            roundedRectangleFigure.setShadowColor(shadowColor);
        }
    }

    public static void refreshNameLabelColor(IPapyrusEditPart editpart, String defaultLabelColor) {
        if (editpart.getPrimaryShape() instanceof IRoundedRectangleFigure && ((GraphicalEditPart)editpart).getModel() instanceof View) {
            IRoundedRectangleFigure roundedRectangleFigure = (IRoundedRectangleFigure)editpart.getPrimaryShape();
            String labelColor = NotationUtils.getStringValue((View)((GraphicalEditPart)editpart).getModel(), "nameBackgroundColor", defaultLabelColor);
            roundedRectangleFigure.setNameBackgroundColor(labelColor);
        }
    }
}

