/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

public enum LineStyleEnum {
    DASH(2, "dash"),
    DASH_DOT(4, "dashDot"),
    DASH_DOT_DOT(5, "dashDotDot"),
    DOT(3, "dot"),
    SOLID(1, "solid"),
    CUSTOM(6, "custom");

    private int lineStyle;
    private String literal;
    private static final LineStyleEnum[] LINE_STYLE_ARRAY;

    static {
        LINE_STYLE_ARRAY = new LineStyleEnum[]{DASH, DASH_DOT, DASH_DOT_DOT, DOT, SOLID, CUSTOM};
    }

    private LineStyleEnum(int lineStyle, String literal) {
        this.lineStyle = lineStyle;
        this.literal = literal;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public String getLiteral() {
        return this.literal;
    }

    public static LineStyleEnum getByLiteral(String literal) {
        int i = 0;
        while (i < LINE_STYLE_ARRAY.length) {
            LineStyleEnum result = LINE_STYLE_ARRAY[i];
            if (result.getLiteral().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.literal;
    }
}

