/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.Activator;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IDirectEditorConstraint;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.definition.DirectEditorExtensionPoint;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.definition.IDirectEditorExtensionPoint;

public class DirectEditorsUtil {
    private static final int UNKNOWN_PRIORITY = 100;

    public static IDirectEditorConfiguration findEditorConfiguration(String language, EObject objectToEdit) {
        return DirectEditorsUtil.findEditorConfiguration(language, objectToEdit, objectToEdit);
    }

    public static IDirectEditorConfiguration findEditorConfiguration(String language, Object semanticObjectToEdit, Object selectedElement) {
        IDirectEditorExtensionPoint extension = DirectEditorsUtil.findEditorExtension(language, semanticObjectToEdit, selectedElement);
        if (extension != null) {
            return extension.getDirectEditorConfiguration();
        }
        return new DefaultDirectEditorConfiguration();
    }

    public static IDirectEditorExtensionPoint findEditorExtension(String language, Object semanticObjectToEdit, Object selectedElement) {
        Collection<IDirectEditorExtensionPoint> configs = DirectEditorsUtil.getDirectEditorExtensions(semanticObjectToEdit, selectedElement);
        IDirectEditorExtensionPoint currentExtension = null;
        int currentPriority = 100;
        for (IDirectEditorExtensionPoint extensionPoint : configs) {
            if (language != null && !language.equals(extensionPoint.getLanguage()) || extensionPoint.getPriority() >= currentPriority) continue;
            currentExtension = extensionPoint;
            currentPriority = extensionPoint.getPriority();
        }
        if (currentExtension == null && language != null) {
            return DirectEditorsUtil.findEditorExtension(null, semanticObjectToEdit, selectedElement);
        }
        return currentExtension;
    }

    public static boolean hasSpecificEditorConfiguration(String language, Object semanticObjectToEdit, Object selectedElement) {
        return DirectEditorsUtil.findEditorExtension(language, semanticObjectToEdit, selectedElement) != null;
    }

    public static boolean hasSpecificEditorConfiguration(EObject objectToEdit) {
        return DirectEditorsUtil.hasSpecificEditorConfiguration(objectToEdit, objectToEdit);
    }

    public static boolean hasSpecificEditorConfiguration(Object semanticObjectToEdit, Object selectedElement) {
        return DirectEditorsUtil.getDirectEditorExtensions(semanticObjectToEdit, selectedElement).size() > 0;
    }

    public static IDirectEditorExtensionPoint getDefaultDirectEditorExtension(Object semanticObjectToEdit) {
        return DirectEditorsUtil.getDefaultDirectEditorExtension(semanticObjectToEdit, semanticObjectToEdit);
    }

    public static IDirectEditorExtensionPoint getDefaultDirectEditorExtension(Object semanticObjectToEdit, Object selectedObject) {
        String language = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + String.valueOf(semanticObjectToEdit.getClass().asSubclass(EObject.class)));
        if ("Simple Direct Editor".equals(language)) {
            return null;
        }
        return DirectEditorsUtil.findEditorExtension(language, semanticObjectToEdit, selectedObject);
    }

    public static Collection<IDirectEditorExtensionPoint> getDirectEditorExtensions(Object semanticObjectToEdit, Object selectedObject) {
        ArrayList<IDirectEditorExtensionPoint> editorExtensionPoints = new ArrayList<IDirectEditorExtensionPoint>();
        IDirectEditorExtensionPoint[] iDirectEditorExtensionPointArray = DirectEditorExtensionPoint.getInstance().getDirectEditorConfigurations();
        int n = iDirectEditorExtensionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDirectEditorConstraint constraint;
            IDirectEditorExtensionPoint configuration = iDirectEditorExtensionPointArray[n2];
            if (configuration.getObjectClassToEdit() != null && configuration.getObjectClassToEdit().isInstance(semanticObjectToEdit) && ((constraint = configuration.getAdditionalConstraint()) == null || constraint.appliesTo(selectedObject))) {
                editorExtensionPoints.add(configuration);
            }
            ++n2;
        }
        return editorExtensionPoints;
    }
}

