/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.edit.policies.effect;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.GMFToolingRuntimePlugin;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.ocl.tracker.OclTracker;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.ocl.tracker.OclTrackerFactory;

public abstract class AbstractOclVisualEffectEditPolicy
extends CanonicalEditPolicy {
    private OclTracker myOclTracker;
    private OclTracker.Registrator myOclRegistrator;
    private final OclTrackerFactory myOclTrackerFactory;

    protected abstract String getExpressionBody();

    public AbstractOclVisualEffectEditPolicy() {
        this(GMFToolingRuntimePlugin.getInstance().getOclTrackerFactory());
    }

    public AbstractOclVisualEffectEditPolicy(OclTrackerFactory.Type factoryType) {
        this(GMFToolingRuntimePlugin.getInstance().getOclTrackerFactory(factoryType));
    }

    public AbstractOclVisualEffectEditPolicy(OclTrackerFactory factory) {
        this.myOclTrackerFactory = factory;
    }

    private OclTracker getOclTracker() {
        if (this.myOclTracker == null) {
            this.myOclTracker = this.myOclTrackerFactory.createOclTracker(this.getExpressionBody(), false);
        }
        return this.myOclTracker;
    }

    private boolean initializeOclTracker() {
        EObject context = this.getContext();
        if (context == null) {
            return false;
        }
        this.getOclTracker().initialize(context);
        return true;
    }

    protected EObject getContext() {
        return this.getSemanticHost();
    }

    protected boolean shouldHandleNotificationEvent(Notification event) {
        return this.getOclTracker().handleNotification(event);
    }

    private void installVisualEffect() {
        if (!this.initializeOclTracker()) {
            return;
        }
        this.getOclTracker().installListeners(this.getHostImpl().getEditingDomain(), new NotificationListener(){

            public void notifyChanged(Notification notification) {
                AbstractOclVisualEffectEditPolicy.this.refreshVisualEffect();
            }
        }, this.getOclRegistrator());
    }

    public void activate() {
        super.activate();
        this.installVisualEffect();
        this.refreshVisualEffect();
    }

    protected void refreshSemantic() {
    }

    public void deactivate() {
        this.getOclTracker().uninstallListeners();
        super.deactivate();
    }

    private void refreshVisualEffect() {
        if (!this.initializeOclTracker()) {
            return;
        }
        this.setVisualEffectValue(this.getOclTracker().getValue());
    }

    protected abstract void setVisualEffectValue(Object var1);

    protected void handleNotificationEvent(Notification event) {
        if (this.shouldHandleNotificationEvent(event)) {
            this.refreshVisualEffect();
        }
    }

    protected final void executeICommand(ICommand command) {
        this.executeCommand((Command)new ICommandProxy(command));
    }

    protected IGraphicalEditPart getHostImpl() {
        return (IGraphicalEditPart)this.getHost();
    }

    protected final List<EObject> getSemanticChildrenList() {
        return Collections.emptyList();
    }

    protected final void ensureHasStyle(EClass styleClass) {
        if (!NotationPackage.eINSTANCE.getStyle().isSuperTypeOf(styleClass)) {
            throw new IllegalArgumentException("Notation Style expected:" + String.valueOf(styleClass));
        }
        IGraphicalEditPart editPart = this.getHostImpl();
        View view = editPart.getNotationView();
        Style style = view.getStyle(styleClass);
        if (style == null) {
            style = (Style)styleClass.getEPackage().getEFactoryInstance().create(styleClass);
            SetRequest request = new SetRequest(editPart.getEditingDomain(), (EObject)view, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Styles(), (Object)style);
            this.executeICommand((ICommand)new SetValueCommand(request));
        }
    }

    protected final OclTracker.Registrator getOclRegistrator() {
        if (this.myOclRegistrator == null) {
            this.myOclRegistrator = new OclTracker.Registrator(){

                @Override
                public void registerListener(String filterId, NotificationListener listener, EObject element) {
                    AbstractOclVisualEffectEditPolicy.this.addListenerFilter(filterId, listener, element);
                }

                @Override
                public void unregisterListener(String filterId) {
                    AbstractOclVisualEffectEditPolicy.this.removeListenerFilter(filterId);
                }
            };
        }
        return this.myOclRegistrator;
    }
}

