/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

public abstract class AdjustAbsoluteBendpointsEditPolicyBase
extends GraphicalEditPolicy {
    private static final String PARAM_CACHED_EDIT_PARTS_SET = AdjustAbsoluteBendpointsEditPolicyBase.class.getName() + ":CachedMovedEPs";

    protected static CachedEditPartsSet getMovedEditPartsSet(ChangeBoundsRequest req) {
        Map extData = req.getExtendedData();
        CachedEditPartsSet set = (CachedEditPartsSet)extData.get(PARAM_CACHED_EDIT_PARTS_SET);
        if (set == null) {
            set = new CachedEditPartsSet(req.getEditParts());
            extData.put(PARAM_CACHED_EDIT_PARTS_SET, set);
        }
        return set;
    }

    protected abstract Command getAdjustLinksCommand(ChangeBoundsRequest var1);

    public boolean understandsRequest(Request req) {
        return req instanceof ChangeBoundsRequest && "move".equals(req.getType());
    }

    public Command getCommand(Request request) {
        if (this.understandsRequest(request)) {
            return this.getAdjustLinksCommand((ChangeBoundsRequest)request);
        }
        return null;
    }

    public IGraphicalEditPart getHost() {
        return (IGraphicalEditPart)super.getHost();
    }

    protected TransactionalEditingDomain getDomain() {
        return this.getHost().getEditingDomain();
    }

    protected static ICommand compose(ICommand c1, ICommand c2) {
        return c1 == null ? c2 : c1.compose((IUndoableOperation)c2);
    }

    protected static String pointList2String(PointList points) {
        return points == null ? "<null>" : Arrays.toString(points.toIntArray());
    }

    protected static Point makeRelative(IFigure f, Point point) {
        Point result = point.getCopy();
        f.translateToRelative((Translatable)result);
        return result;
    }

    protected static PointList makeRelative(IFigure f, PointList points) {
        PointList result = points.getCopy();
        f.translateToRelative((Translatable)result);
        return result;
    }

    protected static Rectangle makeRelative(IFigure f, Rectangle rect) {
        Rectangle result = rect.getCopy();
        f.translateToRelative((Translatable)result);
        return result;
    }

    protected static Point makeAbsolute(IFigure f, Point point) {
        Point result = point.getCopy();
        f.translateToAbsolute((Translatable)result);
        return result;
    }

    protected static PointList makeAbsolute(IFigure f, PointList points) {
        PointList result = points.getCopy();
        f.translateToAbsolute((Translatable)result);
        return result;
    }

    protected static Rectangle makeAbsolute(IFigure f, Rectangle rect) {
        Rectangle result = rect.getCopy();
        f.translateToAbsolute((Translatable)result);
        return result;
    }

    protected static class CachedEditPartsSet {
        private final Set<EditPart> myDirectlyMoved;
        private final Set<EditPart> myKnownIndirectlyYes;
        private final Set<EditPart> myKnownIndirectlyNo;

        public CachedEditPartsSet(List<? extends EditPart> directlyMoved) {
            this.myDirectlyMoved = new HashSet<EditPart>(directlyMoved);
            this.myKnownIndirectlyNo = new HashSet<EditPart>(directlyMoved.size() * 5 + 1);
            this.myKnownIndirectlyYes = new HashSet<EditPart>(directlyMoved.size() * 5 + 1);
        }

        public MovedNodeKind isMoved(EditPart ep) {
            LinkedList<EditPart> chainUp = new LinkedList<EditPart>();
            EditPart cur = ep;
            MovedNodeKind kind = null;
            while (cur != null) {
                kind = this.getKnownKind(cur);
                if (kind != null) break;
                chainUp.add(cur);
                cur = cur.getParent();
            }
            if (cur == null || kind == null) {
                kind = MovedNodeKind.NO;
            } else if (kind == MovedNodeKind.DIRECTLY && cur != ep) {
                kind = MovedNodeKind.INDIRECTLY;
            }
            Set<EditPart> forKind = switch (kind) {
                case MovedNodeKind.DIRECTLY -> this.myDirectlyMoved;
                case MovedNodeKind.INDIRECTLY -> this.myKnownIndirectlyYes;
                case MovedNodeKind.NO -> this.myKnownIndirectlyNo;
                default -> throw new IllegalArgumentException("Wow: " + String.valueOf((Object)kind));
            };
            if (kind != MovedNodeKind.DIRECTLY) {
                forKind.addAll(chainUp);
            }
            return kind;
        }

        private MovedNodeKind getKnownKind(EditPart ep) {
            if (this.myDirectlyMoved.contains(ep)) {
                return MovedNodeKind.DIRECTLY;
            }
            if (this.myKnownIndirectlyYes.contains(ep)) {
                return MovedNodeKind.INDIRECTLY;
            }
            if (this.myKnownIndirectlyNo.contains(ep)) {
                return MovedNodeKind.NO;
            }
            return null;
        }
    }

    protected static enum MovedNodeKind {
        DIRECTLY,
        INDIRECTLY,
        NO;

    }
}

