/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.widgets.editors;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ColorPickerEditor
extends AbstractValueEditor
implements IChangeListener {
    protected Button colorPicker = new Button((Composite)this, 8);
    protected ColorPalettePopup colorPickerPopup;
    protected RGB color;
    protected Rectangle colorBounds;
    protected Image backgroundImage;
    protected int defaultColor = 0;
    public static final Rectangle defaultColorBoundsWithoutImage = new Rectangle(0, 0, 15, 15);
    public static final Rectangle defaultColorBoundsWithImage = new Rectangle(0, 12, 16, 4);

    public ColorPickerEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetColor(0);
        this.colorPicker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorPalettePopup colorPickerPopup = new ColorPalettePopup(ColorPickerEditor.this.getShell(), 25);
                colorPickerPopup.setPreviousColor(ColorPickerEditor.this.getValue().intValue());
                Rectangle r = ColorPickerEditor.this.colorPicker.getBounds();
                Point location = ColorPickerEditor.this.colorPicker.getParent().toDisplay(r.x, r.y);
                colorPickerPopup.open(new Point(location.x, location.y + r.height));
                if (colorPickerPopup.getSelectedColor() == null && !colorPickerPopup.useDefaultColor()) {
                    return;
                }
                ColorPickerEditor.this.setColor(colorPickerPopup.getSelectedColor());
                ColorPickerEditor.this.commit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public ColorPickerEditor(Composite parent, int style, int defaultColor) {
        this(parent, style);
        this.defaultColor = defaultColor;
        this.doSetColor(defaultColor);
    }

    protected void doBinding() {
        if (this.modelProperty != null) {
            this.getParent().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ColorPickerEditor.this.dispose();
                }
            });
            this.modelProperty.addChangeListener((IChangeListener)this);
            this.handleChange(null);
        }
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    private void setColor(RGB color) {
        int colorValue = color == null ? this.defaultColor : FigureUtilities.RGBToInteger((RGB)color);
        this.doSetColor(colorValue);
        if (this.modelProperty != null) {
            this.modelProperty.setValue((Object)colorValue);
        }
    }

    private void doSetColor(int color) {
        this.color = FigureUtilities.integerToRGB((Integer)color);
        this.updateButton();
    }

    private void updateButton() {
        Image image = this.colorPicker.getImage();
        if (image != null) {
            image.dispose();
        }
        Display display = this.colorPicker.getDisplay();
        Color color = new Color((Device)display, this.color);
        image = this.backgroundImage == null ? new Image((Device)display, 16, 16) : new Image((Device)display, this.backgroundImage.getBounds());
        GC gc = new GC((Drawable)image);
        gc.fillRectangle(image.getBounds());
        gc.setBackground(this.colorPicker.getBackground());
        gc.fillRectangle(image.getBounds());
        gc.setBackground(color);
        gc.setForeground(color);
        if (this.backgroundImage != null) {
            gc.fillRectangle(defaultColorBoundsWithImage);
            gc.drawImage(this.backgroundImage, 0, 0);
        } else {
            gc.fillRectangle(defaultColorBoundsWithoutImage);
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(defaultColorBoundsWithoutImage);
        }
        gc.dispose();
        color.dispose();
        this.colorPicker.setImage(image);
    }

    public void setImage(Image image) {
        this.backgroundImage = image;
    }

    public void setColorBounds(Rectangle rectangle) {
        this.colorBounds = rectangle;
    }

    public Integer getValue() {
        if (this.color == null) {
            return this.defaultColor;
        }
        return FigureUtilities.RGBToInteger((RGB)this.color);
    }

    public Object getEditableType() {
        return Integer.class;
    }

    public void setReadOnly(boolean readOnly) {
        this.colorPicker.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.colorPicker.isEnabled();
    }

    public void setToolTipText(String text) {
        this.setLabelToolTipText(text);
    }

    public void handleChange(ChangeEvent event) {
        if (this.modelProperty != null) {
            Integer value = (Integer)this.modelProperty.getValue();
            if (value == null) {
                value = 0;
            }
            this.doSetColor(value);
        }
    }

    public void refreshValue() {
        this.handleChange(null);
    }

    public void setDefaultColor(int color) {
        this.defaultColor = color;
    }
}

