/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.handlers.PolicyDefinedTableHandler;
import org.eclipse.papyrus.infra.nattable.common.internal.command.ITableCreationCommand;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableViewPrototype
extends ViewPrototype {
    private TableConfiguration configuration;
    private ITableCreationCommand creationCommand;

    public TableViewPrototype(PapyrusTable prototype) {
        this(prototype, null);
    }

    public TableViewPrototype(PapyrusTable prototype, ITableCreationCommand creationCommand) {
        super((PapyrusRepresentationKind)prototype);
        this.configuration = prototype.getConfiguration();
        this.creationCommand = creationCommand;
    }

    public TableConfiguration getTableConfiguration() {
        return this.configuration;
    }

    public boolean isOwnerReassignable() {
        return true;
    }

    public boolean instantiateOn(EObject owner) {
        return this.instantiateOn(owner, null);
    }

    public boolean instantiateOn(EObject owner, String name) {
        if (this.configuration == null) {
            return false;
        }
        if (this.creationCommand != null) {
            ModelSet modelSet;
            ServicesRegistry registry;
            try {
                registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(owner);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
                return false;
            }
            try {
                modelSet = (ModelSet)registry.getService(ModelSet.class);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
                return false;
            }
            Table result = this.creationCommand.createTable(modelSet, owner, owner, this, name, true);
            return result != null;
        }
        PolicyDefinedTableHandler handler = new PolicyDefinedTableHandler(this.configuration, owner, name);
        return handler.execute(this);
    }

    public Command getCommandChangeOwner(EObject view, final EObject target) {
        final Table table = (Table)view;
        final EObject previous = table.getOwner();
        return new AbstractCommand("Change table owner"){

            public void execute() {
                table.setOwner(target);
            }

            public void undo() {
                table.setOwner(previous);
            }

            public void redo() {
                table.setOwner(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public Command getCommandChangeRoot(EObject view, final EObject target) {
        final Table table = (Table)view;
        final EObject previous = table.getContext();
        return new AbstractCommand("Change table root element"){

            public void execute() {
                table.setContext(target);
            }

            public void undo() {
                table.setContext(previous);
            }

            public void redo() {
                table.setContext(target);
            }

            protected boolean prepare() {
                return true;
            }
        };
    }

    public EObject getOwnerOf(EObject view) {
        return ((Table)view).getOwner();
    }

    public EObject getRootOf(EObject view) {
        return ((Table)view).getContext();
    }
}

