/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.renderers.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.renderers.SectionRendererProvider;
import org.eclipse.papyrus.infra.properties.ui.renderers.SectionRendererService;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public class SectionRendererServiceImpl
implements SectionRendererService {
    private final Set<SectionRendererProvider> providers = new HashSet<SectionRendererProvider>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void registerSectionProvider(SectionRendererProvider provider) {
        this.providers.add(provider);
    }

    public void unregisterSectionProvider(SectionRendererProvider provider) {
        this.providers.remove(provider);
    }

    @Override
    public ISectionDescriptor getSectionDescriptor(Section section, View view, DisplayEngine display) {
        double highestPriority = Double.MIN_VALUE;
        SectionRendererProvider currentProvider = null;
        for (SectionRendererProvider provider : this.providers) {
            double priority = provider.getPriority(section, view, display);
            if (Double.isNaN(priority) || currentProvider != null && !(priority > highestPriority)) continue;
            highestPriority = priority;
            currentProvider = provider;
        }
        return currentProvider.getSectionDescriptor(section, view, display);
    }
}

