/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.dialogs;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.ui.architecture.ArchitectureUIPlugin;
import org.eclipse.papyrus.infra.ui.architecture.widgets.ArchitectureContextComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ArchitectureContextDialog
extends Dialog {
    private static final String DIALOG_SECTION = ArchitectureContextDialog.class.getName();
    private String[] originalContextIds;
    private String[] selectedContextIds;
    private String[] selectedViewpointIds;
    private String shellTitle;
    private String labelText;

    public ArchitectureContextDialog(Shell parentShell, String shellTitle, String labelText) {
        super(parentShell);
        this.shellTitle = shellTitle;
        this.labelText = labelText;
    }

    public String[] getSelectedContextIds() {
        return this.selectedContextIds;
    }

    public String[] getSelectedViewpointIds() {
        return this.selectedViewpointIds;
    }

    public void setSelectedContexts(String[] selectedContextIds) {
        this.selectedContextIds = selectedContextIds;
        this.originalContextIds = selectedContextIds;
    }

    public void setSelectedViewpoints(String[] selectedViewpointIds) {
        this.selectedViewpointIds = selectedViewpointIds;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText(this.labelText);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        final ArchitectureContextComposite acc = new ArchitectureContextComposite(container, 1, 1, 1808, 0, 0);
        acc.setAllowSeveralContexts(false);
        acc.setSelectedContexts(this.selectedContextIds);
        acc.setSelectedViewpoints(this.selectedViewpointIds);
        acc.setInput(manager.getVisibleArchitectureContexts().toArray(new MergedArchitectureContext[0]));
        acc.setUpdater(new ArchitectureContextComposite.Updater(){

            @Override
            public void update() {
                ArchitectureContextDialog.this.selectedContextIds = acc.getSelectedContexts();
                ArchitectureContextDialog.this.selectedViewpointIds = acc.getSelectedViewpoints();
            }
        });
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.shellTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings globalSettings = ArchitectureUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings dialogSettings = globalSettings.getSection(DIALOG_SECTION);
        if (dialogSettings == null) {
            dialogSettings = globalSettings.addNewSection(DIALOG_SECTION);
        }
        return dialogSettings;
    }

    protected void okPressed() {
        if (!Arrays.equals(this.getSelectedContextIds(), this.originalContextIds)) {
            MessageBox messageBox = new MessageBox(this.getShell(), 200);
            messageBox.setMessage("Changing the architecture context may cause significant changes to the model.\nDo you like to proceed?");
            messageBox.setText("Warning");
            int response = messageBox.open();
            if (response != 64) {
                return;
            }
        }
        super.okPressed();
    }
}

