/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.dialog;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.tools.databinding.MultipleObservableValue;
import org.eclipse.papyrus.infra.ui.emf.databinding.EObjectObservableValueEditingSupport;
import org.eclipse.papyrus.infra.ui.emf.databinding.EObjectStructuredObservableValue;
import org.eclipse.papyrus.infra.ui.emf.providers.EObjectObservableValueContentProvider;
import org.eclipse.papyrus.infra.ui.emf.providers.EObjectObservableValueLabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeReferenceValueEditor;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingStyledLabelProvider;
import org.eclipse.swt.widgets.Composite;

public class EObjectTreeReferenceValueEditor
extends TreeReferenceValueEditor {
    protected MultipleObservableValue multipleObservableValue = new MultipleObservableValue();

    public EObjectTreeReferenceValueEditor(Composite parent, int style) {
        super(parent, style);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    EObjectTreeReferenceValueEditor.this.unsetButton.setEnabled(false);
                } else {
                    EObjectTreeReferenceValueEditor.this.unsetButton.setEnabled(true);
                }
            }
        });
    }

    public void setValueRootContentProvider() {
        if (this.treeViewer != null && this.treeViewer.getContentProvider() instanceof EObjectObservableValueContentProvider) {
            ((EObjectObservableValueContentProvider)this.treeViewer.getContentProvider()).setValueRoot(this.multipleObservableValue);
        }
    }

    public void setProvidersTreeViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new EObjectObservableValueContentProvider(this.multipleObservableValue));
        if (this.labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new EObjectObservableValueLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider));
        } else {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new EObjectObservableValueLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegatingStyledLabelProvider(this.labelProvider)));
        }
        this.treeViewer.setInput((Object)"");
        if (this.tree != null && this.tree.getTopItem() != null) {
            this.treeViewer.expandToLevel(this.tree.getTopItem().getData(), 10);
        }
    }

    public IObservableValue createWidgetObservable(IObservableValue modelProperty) {
        this.multipleObservableValue.getObservableValues().clear();
        if (modelProperty.getValue() instanceof EObject) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)((EObject)modelProperty.getValue()));
            this.multipleObservableValue.getObservableValues().add(new EObjectStructuredObservableValue((EObject)modelProperty.getValue(), null, (EditingDomain)editingDomain, true, null));
        } else if (modelProperty.getValue() instanceof List) {
            for (Object object : (List)modelProperty.getValue()) {
                if (!(object instanceof EObject)) continue;
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain(object);
                this.multipleObservableValue.getObservableValues().add(new EObjectStructuredObservableValue((EObject)object, null, (EditingDomain)editingDomain, true, null));
            }
        }
        return this.multipleObservableValue;
    }

    public EditingSupport createEditingSupport() {
        return new EObjectObservableValueEditingSupport((ColumnViewer)this.treeViewer, this.valueFactory);
    }

    public void unsetAction() {
        Object valueModelProperty = this.modelProperty.getValue();
        if (valueModelProperty instanceof EObject) {
            this.setValue(null);
        } else if (valueModelProperty instanceof List) {
            ITreeSelection structuredSelection = this.treeViewer.getStructuredSelection();
            BasicEList eList = new BasicEList((Collection)((List)valueModelProperty));
            for (Object selection : structuredSelection.toList()) {
                EObjectStructuredObservableValue rootObservableValue;
                if (!(selection instanceof EObjectStructuredObservableValue) || !eList.contains((rootObservableValue = this.getRootObservableValue((EObjectStructuredObservableValue)((Object)selection))).getObserved())) continue;
                eList.remove(rootObservableValue.getObserved());
            }
            this.setValue(eList);
        }
        this.checkCreateInstanceButton();
    }

    private EObjectStructuredObservableValue getRootObservableValue(EObjectStructuredObservableValue observableValue) {
        EObjectStructuredObservableValue parentRoot = observableValue;
        if (observableValue.getParent() != null) {
            parentRoot = this.getRootObservableValue(observableValue.getParent());
        }
        return parentRoot;
    }

    public void checkCreateInstanceButton() {
        Object valueType;
        if (this.modelProperty != null && this.modelProperty.getValueType() != null && (valueType = this.modelProperty.getValueType()) instanceof EReference) {
            int upperBound = ((EReference)valueType).getUpperBound();
            int size = this.multipleObservableValue.getObservableValues().size();
            if (-1 != upperBound && size >= upperBound) {
                this.createInstanceButton.setEnabled(false);
            } else {
                this.createInstanceButton.setEnabled(true);
            }
        }
    }
}

