/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public abstract class AbstractViewTypeHelper<T extends PapyrusRepresentationKind>
implements IViewTypeHelper {
    private final Class<T> representationType;
    private final Map<T, ViewPrototype> cache = new HashMap<T, ViewPrototype>();

    protected AbstractViewTypeHelper(Class<T> representationType) {
        this.representationType = representationType;
    }

    protected final Class<T> getRepresentationType() {
        return this.representationType;
    }

    @Override
    public boolean isSupported(EClass type) {
        return this.getRepresentationType().isAssignableFrom(type.getInstanceClass());
    }

    @Override
    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind kind) {
        if (!this.isSupported(kind.eClass())) {
            return null;
        }
        PapyrusRepresentationKind specificKind = (PapyrusRepresentationKind)this.getRepresentationType().cast(kind);
        ViewPrototype result = this.cache.get(specificKind);
        if (result != null) {
            if (result.isUnavailable()) {
                result = null;
            }
            return result;
        }
        result = this.doGetPrototypeFor(specificKind);
        if (result == null) {
            this.cache.put(specificKind, ViewPrototype.UNAVAILABLE_VIEW);
        } else {
            this.cache.put(specificKind, result);
        }
        return result;
    }

    protected abstract ViewPrototype doGetPrototypeFor(T var1);

    @Override
    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        return this.doGetPrototypeOf(view);
    }

    protected abstract ViewPrototype doGetPrototypeOf(EObject var1);

    protected PolicyChecker getPolicyChecker(EObject view) {
        return PolicyChecker.getFor(view);
    }
}

