/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.controlmode.profile.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.controlmode.profile.Activator;
import org.eclipse.papyrus.uml.controlmode.profile.helpers.SafeDialogOpenerDuringValidation;

public class UMLValidationProvider {
    private static boolean constraintsActive = false;
    protected static final Collection<String> SELF_MANAGING_CONSTRAINTS = Arrays.asList("org.eclipse.papyrus.uml.controlmode.profile.validation.ProfileApplicationDuplicationChecker");

    static {
        ModelValidationService.getInstance().addValidationListener((IValidationListener)new ValidationReportListener());
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.controlmode.profile", "Validation failed", (Throwable)e));
            }
        } else {
            task.run();
        }
    }

    static String formatElement(EObject object) {
        return EMFCoreUtil.getQualifiedName((EObject)object, (boolean)true);
    }

    public static class DefaultCtx
    implements IClientSelector {
        public boolean selects(Object object) {
            EObject eObj;
            Resource resource;
            if (constraintsActive) {
                return true;
            }
            if (object instanceof EObject && (resource = (eObj = (EObject)object).eResource()) != null) {
                ResourceSet set = resource.getResourceSet();
                return set instanceof ModelSet;
            }
            return false;
        }
    }

    private static class ValidationReportListener
    implements IValidationListener {
        private ValidationReportListener() {
        }

        public void validationOccurred(ValidationEvent event) {
            boolean needReport = false;
            if (event.getSeverity() >= 2) {
                needReport = true;
            }
            if (needReport && event.getEvaluationMode().isLive()) {
                StringBuffer messageBuff = new StringBuffer();
                LinkedList<String> handledConstraints = new LinkedList<String>(SELF_MANAGING_CONSTRAINTS);
                for (IConstraintStatus status : event.getValidationResults()) {
                    if (status.getSeverity() < event.getSeverity()) continue;
                    String constraintId = status.getConstraint().getDescriptor().getId();
                    String constraintPlugin = status.getConstraint().getDescriptor().getPluginId();
                    if (!"org.eclipse.papyrus.uml.controlmode.profile".equals(constraintPlugin) || handledConstraints.contains(constraintId)) continue;
                    handledConstraints.add(constraintId);
                    messageBuff.append(status.getMessage());
                }
                if (messageBuff.length() == 0) {
                    return;
                }
                final String message = messageBuff.toString();
                if (event.getSeverity() >= 4) {
                    opener = new SafeDialogOpenerDuringValidation<Void>(){

                        @Override
                        protected Void openDialog() {
                            NotificationBuilder.createWarningPopup((String)message).run();
                            return null;
                        }
                    };
                    opener.execute();
                } else {
                    opener = new SafeDialogOpenerDuringValidation<Void>(){

                        @Override
                        protected Void openDialog() {
                            NotificationBuilder.createInfoPopup((String)message).run();
                            return null;
                        }
                    };
                    opener.execute();
                }
            }
        }
    }
}

