/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.View;

public class ReconnectToIntersectionPoints
extends Command {
    CreateConnectionViewAndElementRequest createRequest = null;
    CompoundCommand compoundCmd;

    public ReconnectToIntersectionPoints(CreateConnectionViewAndElementRequest request) {
        this.createRequest = request;
        this.compoundCmd = new CompoundCommand();
        this.compoundCmd.setLabel("Anchor ends at intersection points");
        this.compoundCmd.setDebugLabel("Debug: Anchor ends at intersection points");
    }

    public boolean canExecute() {
        return super.canExecute() && this.createRequest != null;
    }

    public void execute() {
        super.execute();
        CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = this.createRequest.getConnectionViewDescriptor();
        View view = (View)viewDescriptor.getAdapter(View.class);
        if (view == null) {
            return;
        }
        EditPartViewer viewer = this.createRequest.getSourceEditPart().getViewer();
        ConnectionEditPart connEP = (ConnectionEditPart)viewer.getEditPartRegistry().get(view);
        connEP.getFigure().getUpdateManager().performUpdate();
        ReconnectRequest sourceRequest = ReconnectToIntersectionPoints.buildReconnectRequest(connEP, true);
        ReconnectRequest targetRequest = ReconnectToIntersectionPoints.buildReconnectRequest(connEP, false);
        this.compoundCmd.add(ReconnectToIntersectionPoints.getCommand((Request)sourceRequest, (GraphicalEditPart)connEP.getSource()));
        this.compoundCmd.add(ReconnectToIntersectionPoints.getCommand((Request)targetRequest, (GraphicalEditPart)connEP.getTarget()));
        if (this.compoundCmd.size() > 0) {
            this.compoundCmd.execute();
        }
    }

    public void undo() {
        super.undo();
        if (this.compoundCmd.size() > 0) {
            this.compoundCmd.undo();
        }
    }

    public void redo() {
        super.redo();
        if (this.compoundCmd.size() > 0) {
            this.compoundCmd.redo();
        }
    }

    public static ReconnectRequest buildReconnectRequest(ConnectionEditPart connEP, boolean isSource) {
        EditPart targetEP;
        String type;
        Point p = ReconnectToIntersectionPoints.getIntersectionPoint(connEP, isSource);
        if (isSource) {
            type = "Reconnection source";
            targetEP = connEP.getSource();
        } else {
            type = "Reconnection target";
            targetEP = connEP.getTarget();
        }
        ReconnectRequest reconnReq = new ReconnectRequest();
        reconnReq.setConnectionEditPart((org.eclipse.gef.ConnectionEditPart)connEP);
        reconnReq.setLocation(p);
        reconnReq.setTargetEditPart(targetEP);
        reconnReq.setType((Object)type);
        return reconnReq;
    }

    public static Point getIntersectionPoint(ConnectionEditPart connEP, boolean source) {
        NodeEditPart sourceEP = (NodeEditPart)connEP.getSource();
        NodeEditPart targetEP = (NodeEditPart)connEP.getTarget();
        ConnectionAnchor sourceAnchor = sourceEP.getSourceConnectionAnchor((org.eclipse.gef.ConnectionEditPart)connEP);
        ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((org.eclipse.gef.ConnectionEditPart)connEP);
        Point endLocation = source ? sourceAnchor.getLocation(targetAnchor.getReferencePoint()).getCopy() : targetAnchor.getLocation(sourceAnchor.getReferencePoint()).getCopy();
        return endLocation;
    }

    public static Command getCommand(Request request, GraphicalEditPart graphicalEP) {
        return graphicalEP.getEditPolicy((Object)"GraphicalNodeEditPolicy").getCommand(request);
    }

    public static void modifyLocation(ReconnectRequest reconnectRequest) {
        Point endLocation;
        ShapeNodeEditPart sourceEP = (ShapeNodeEditPart)reconnectRequest.getConnectionEditPart().getSource();
        ShapeNodeEditPart targetEP = (ShapeNodeEditPart)reconnectRequest.getConnectionEditPart().getTarget();
        if (reconnectRequest.isMovingStartAnchor()) {
            sourceEP = (ShapeNodeEditPart)reconnectRequest.getTarget();
            ConnectionAnchor sourceAnchor = sourceEP.getSourceConnectionAnchor((Request)reconnectRequest);
            ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor(reconnectRequest.getConnectionEditPart());
            endLocation = sourceAnchor.getLocation(targetAnchor.getReferencePoint()).getCopy();
        } else {
            targetEP = (ShapeNodeEditPart)reconnectRequest.getTarget();
            ConnectionAnchor sourceAnchor = sourceEP.getSourceConnectionAnchor(reconnectRequest.getConnectionEditPart());
            ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((Request)reconnectRequest);
            endLocation = targetAnchor.getLocation(sourceAnchor.getReferencePoint()).getCopy();
        }
        reconnectRequest.setLocation(endLocation);
    }
}

