/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.FloatingMessageAnchor;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;

public class CustomFullLifelineEditPartCN
extends FullLifelineEditPartCN {
    public CustomFullLifelineEditPartCN(View view) {
        super(view);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        FullLifelineFigure lifelineFigure = (FullLifelineFigure)FigureUtils.findChildFigureInstance((IFigure)this.getFigure(), FullLifelineFigure.class);
        lifelineFigure.setSelected(value != 0);
        this.getFigure().getParent().repaint();
    }

    @Override
    protected NodeFigure createNodeFigure() {
        NodeFigure nodeFigure = super.createNodeFigure();
        final FullLifelineFigure lifelineFigure = (FullLifelineFigure)FigureUtils.findChildFigureInstance((IFigure)nodeFigure, FullLifelineFigure.class);
        lifelineFigure.getLifelineDataContainerFigure().setLayoutManager((LayoutManager)new AbstractLayout(){

            public void layout(IFigure container) {
                int timeRulerHeight = 30;
                boolean displayTimeRuler = lifelineFigure.isDisplayTimeRuler();
                Rectangle clientArea = container.getClientArea();
                List children = container.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    if (child == lifelineFigure.getChronogramContainerFigure()) {
                        if (displayTimeRuler) {
                            child.setBounds(new Rectangle(clientArea).getResized(0, -30));
                        } else {
                            child.setBounds(clientArea);
                        }
                    } else if (child == lifelineFigure.getTimeRulerContainerFigure()) {
                        if (displayTimeRuler) {
                            Rectangle bounds = new Rectangle(clientArea);
                            bounds.height = 30;
                            bounds.y = clientArea.y + clientArea.height - 30;
                            child.setBounds(bounds);
                        } else {
                            child.setBounds(new Rectangle(clientArea.x, clientArea.y + clientArea.height, clientArea.width, 0));
                        }
                    }
                    ++i;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
        return nodeFigure;
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTrackerEx((EditPart)this){

            protected boolean handleDragStarted() {
                this.lockTargetEditPart(CustomFullLifelineEditPartCN.this.getParent());
                return super.handleDragStarted();
            }
        };
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return new FloatingMessageAnchor(connEditPart, new Point(20, -20));
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return new FloatingMessageAnchor(connEditPart, new Point(-20, 20));
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof CreateRequest) {
            return new XYAnchor(MessageUtils.getLastStartLocation());
        }
        return super.getTargetConnectionAnchor(request);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof LocationRequest) {
            LocationRequest locationRequest = (LocationRequest)request;
            return new XYAnchor(locationRequest.getLocation());
        }
        return super.getTargetConnectionAnchor(request);
    }
}

