/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;

public class AssociationFigure
extends UMLEdgeFigure {
    public static final int navigable = 1;
    public static final int owned = 8;
    private WrappingLabel fAssociationNameLabel;
    private WrappingLabel fMultiplicitySourceLabel;
    private WrappingLabel fMultiplicityTargetLabel;
    private WrappingLabel fRoleSourceLabel;
    private WrappingLabel fRoleTargetLabel;
    private int sourceType;
    private int targetType;

    public AssociationFigure() {
        this.setAntialias(1);
        this.createContents();
    }

    public AssociationFigure(int sourceType, int targetType) {
        this.setEnd(sourceType, targetType);
        this.createContents();
    }

    protected void createContents() {
        super.createContents();
        this.fAssociationNameLabel = new PapyrusWrappingLabel();
        this.fAssociationNameLabel.setText("");
        this.add((IFigure)this.fAssociationNameLabel);
        this.fMultiplicitySourceLabel = new PapyrusWrappingLabel();
        this.fMultiplicitySourceLabel.setText("");
        this.add((IFigure)this.fMultiplicitySourceLabel);
        this.fMultiplicityTargetLabel = new PapyrusWrappingLabel();
        this.fMultiplicityTargetLabel.setText("");
        this.add((IFigure)this.fMultiplicityTargetLabel);
        this.fRoleSourceLabel = new PapyrusWrappingLabel();
        this.fRoleSourceLabel.setText("");
        this.add((IFigure)this.fRoleSourceLabel);
        this.fRoleTargetLabel = new PapyrusWrappingLabel();
        this.fRoleTargetLabel.setText("");
        this.add((IFigure)this.fRoleTargetLabel);
    }

    public RotatableDecoration getDecoration(int typeDecoration) {
        int remain = typeDecoration % 8;
        int navigationValue = remain / 1;
        if (navigationValue == 1) {
            return this.getNavigationDecoration();
        }
        return null;
    }

    protected RotatableDecoration getNavigationDecoration() {
        PolylineDecoration dec = new PolylineDecoration();
        dec.setScale(15.0, 5.0);
        dec.setLineWidth(1);
        return dec;
    }

    public void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        super.paintFigure(graphics);
    }

    public void setEnd(int sourceType, int targetType) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.setSourceDecoration(this.getDecoration(sourceType));
        this.setTargetDecoration(this.getDecoration(targetType));
    }

    public void resetStyle() {
        super.resetStyle();
        this.setSourceDecoration(this.getDecoration(this.sourceType));
        this.setTargetDecoration(this.getDecoration(this.targetType));
    }

    public WrappingLabel getAssociationNameLabel() {
        return this.fAssociationNameLabel;
    }

    public WrappingLabel getMultiplicitySourceLabel() {
        return this.fMultiplicitySourceLabel;
    }

    public WrappingLabel getMultiplicityTargetLabel() {
        return this.fMultiplicityTargetLabel;
    }

    public WrappingLabel getRoleSourceLabel() {
        return this.fRoleSourceLabel;
    }

    public WrappingLabel getRoleTargetLabel() {
        return this.fRoleTargetLabel;
    }
}

