/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.concurrent;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.papyrus.uml.m2m.qvto.common.Activator;

public class ExecutorsPool {
    protected boolean cacheTransformations = true;
    private final int poolSize;
    private final Map<URI, Pool> executors = new HashMap<URI, Pool>();
    private final Map<TransformationExecutor, URI> executorsURIs = new HashMap<TransformationExecutor, URI>();

    public ExecutorsPool(int size) {
        this.poolSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformationExecutor getExecutor(URI transformationURI) {
        if (!this.cacheTransformations) {
            return new Pool(transformationURI).createExecutor();
        }
        Map<URI, Pool> map = this.executors;
        synchronized (map) {
            if (!this.executors.containsKey(transformationURI)) {
                this.executors.put(transformationURI, new Pool(transformationURI));
            }
        }
        Pool pool = this.executors.get(transformationURI);
        return pool.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IStatus preLoad(URI transformationURI) {
        if (!this.cacheTransformations) {
            return Status.OK_STATUS;
        }
        ExecutorsPool executorsPool = this;
        synchronized (executorsPool) {
            if (!this.executors.containsKey(transformationURI)) {
                Pool pool = new Pool(transformationURI);
                this.executors.put(transformationURI, pool);
                pool.preload();
            }
        }
        return Status.OK_STATUS;
    }

    public void releaseExecutor(TransformationExecutor executor) {
        if (!this.cacheTransformations) {
            return;
        }
        URI transformationURI = this.executorsURIs.get(executor);
        Pool pool = this.executors.get(transformationURI);
        pool.release(executor);
    }

    private class Pool {
        private List<TransformationExecutor> allExecutors = new LinkedList<TransformationExecutor>();
        private List<TransformationExecutor> busyExecutors = new LinkedList<TransformationExecutor>();
        private final URI transformationURI;

        public Pool(URI transformationURI) {
            this.transformationURI = transformationURI;
        }

        public void preload() {
            int i = 0;
            while (i < ExecutorsPool.this.poolSize) {
                this.createExecutor();
                ++i;
            }
            this.busyExecutors.clear();
        }

        public synchronized void release(TransformationExecutor executor) {
            this.busyExecutors.remove(executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransformationExecutor getExecutor() {
            while (true) {
                Pool pool = this;
                synchronized (pool) {
                    for (TransformationExecutor executor : this.allExecutors) {
                        if (!this.isAvailable(executor)) continue;
                        return this.getExecutor(executor);
                    }
                    if (this.allExecutors.size() < ExecutorsPool.this.poolSize) {
                        return this.createExecutor();
                    }
                }
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException ex) {
                    Activator.log.error((Throwable)ex);
                    return null;
                }
            }
        }

        private boolean isAvailable(TransformationExecutor executor) {
            return !this.busyExecutors.contains(executor);
        }

        private TransformationExecutor getExecutor(TransformationExecutor executor) {
            this.busyExecutors.add(executor);
            return executor;
        }

        private TransformationExecutor createExecutor() {
            TransformationExecutor executor = new TransformationExecutor(this.transformationURI);
            executor.loadTransformation();
            this.allExecutors.add(executor);
            ExecutorsPool.this.executorsURIs.put(executor, this.transformationURI);
            return this.getExecutor(executor);
        }
    }
}

