/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.editor;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.commands.ApplyStereotypeCommand;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeApplierCellEditorWrapper
implements ICellEditor {
    protected final ICellEditor wrappedCellEditor;
    protected final Object axisElement;
    protected final ITableAxisElementProvider elementProvider;

    public StereotypeApplierCellEditorWrapper(ICellEditor wrappedCellEditor, Object axisElement, ITableAxisElementProvider elementProvider) {
        this.wrappedCellEditor = wrappedCellEditor;
        this.axisElement = axisElement;
        this.elementProvider = elementProvider;
    }

    public Control activateCell(Composite parent, Object originalCanonicalValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
        int columnIndex = cell.getColumnIndex();
        int rowIndex = cell.getRowIndex();
        Object row = this.elementProvider.getRowElement(rowIndex);
        Object column = this.elementProvider.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Element editedElement = null;
        Object feature = null;
        if (row instanceof EObject && column == this.axisElement) {
            editedElement = (Element)row;
            feature = column;
        } else {
            editedElement = (Element)column;
            feature = row;
        }
        if (!(feature instanceof EStructuralFeature)) {
            String id = AxisUtils.getPropertyId((Object)this.axisElement);
            StereotypeApplierCellEditorWrapper.applyRequiredStereotype(editedElement, id);
        }
        return this.wrappedCellEditor.activateCell(parent, originalCanonicalValue, editMode, editHandler, cell, configRegistry);
    }

    public int getColumnIndex() {
        return this.wrappedCellEditor.getColumnIndex();
    }

    public int getRowIndex() {
        return this.wrappedCellEditor.getRowIndex();
    }

    public int getColumnPosition() {
        return this.wrappedCellEditor.getColumnPosition();
    }

    public int getRowPosition() {
        return this.wrappedCellEditor.getRowPosition();
    }

    public Object getEditorValue() {
        return this.wrappedCellEditor.getEditorValue();
    }

    public void setEditorValue(Object value) {
        this.wrappedCellEditor.setEditorValue(value);
    }

    public Object getCanonicalValue() {
        return this.wrappedCellEditor.getCanonicalValue();
    }

    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        return this.wrappedCellEditor.getCanonicalValue(conversionErrorHandler);
    }

    public void setCanonicalValue(Object canonicalValue) {
        this.wrappedCellEditor.setCanonicalValue(canonicalValue);
    }

    public boolean validateCanonicalValue(Object canonicalValue) {
        return this.wrappedCellEditor.validateCanonicalValue(canonicalValue);
    }

    public boolean validateCanonicalValue(Object canonicalValue, IEditErrorHandler validationErrorHandler) {
        return this.wrappedCellEditor.validateCanonicalValue(canonicalValue, validationErrorHandler);
    }

    public boolean commit(SelectionLayer.MoveDirectionEnum direction) {
        return this.wrappedCellEditor.commit(direction);
    }

    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        return this.wrappedCellEditor.commit(direction, closeAfterCommit);
    }

    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit, boolean skipValidation) {
        return this.wrappedCellEditor.commit(direction, closeAfterCommit, skipValidation);
    }

    public void close() {
        this.wrappedCellEditor.close();
    }

    public boolean isClosed() {
        return this.wrappedCellEditor.isClosed();
    }

    public Control getEditorControl() {
        return this.wrappedCellEditor.getEditorControl();
    }

    public Control createEditorControl(Composite parent) {
        return this.wrappedCellEditor.createEditorControl(parent);
    }

    public boolean openInline(IConfigRegistry configRegistry, List<String> configLabels) {
        return this.wrappedCellEditor.openInline(configRegistry, configLabels);
    }

    public boolean supportMultiEdit(IConfigRegistry configRegistry, List<String> configLabels) {
        return this.wrappedCellEditor.supportMultiEdit(configRegistry, configLabels);
    }

    public boolean openAdjacentEditor() {
        return this.wrappedCellEditor.openAdjacentEditor();
    }

    public boolean activateAtAnyPosition() {
        return this.wrappedCellEditor.activateAtAnyPosition();
    }

    public void addEditorControlListeners() {
        this.wrappedCellEditor.addEditorControlListeners();
    }

    public void removeEditorControlListeners() {
        this.wrappedCellEditor.removeEditorControlListeners();
    }

    private static final boolean applyRequiredStereotype(Element el, String propertyId) {
        List<Stereotype> stereotypesList;
        if (UMLTableUtils.getAppliedStereotypesWithThisProperty(el, propertyId).size() == 0 && (stereotypesList = UMLTableUtils.getApplicableStereotypesWithThisProperty(el, propertyId)).size() == 1) {
            TransactionalEditingDomain domain = null;
            try {
                domain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)el);
                ApplyStereotypeCommand applyCommand = new ApplyStereotypeCommand(el, stereotypesList.get(0), domain);
                domain.getCommandStack().execute((Command)applyCommand);
                return true;
            }
            catch (ServiceException e) {
                Activator.log.error("EditingDomain not found", (Throwable)e);
            }
        }
        return false;
    }

    public boolean openMultiEditDialog() {
        return this.wrappedCellEditor == null ? false : this.wrappedCellEditor.openMultiEditDialog();
    }

    public Rectangle calculateControlBounds(Rectangle cellBounds) {
        return this.wrappedCellEditor == null ? cellBounds : this.wrappedCellEditor.calculateControlBounds(cellBounds);
    }

    public boolean activateOnTraversal(IConfigRegistry configRegistry, List<String> configLabels) {
        return false;
    }
}

