/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.creation;

import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.infra.widgets.creation.StringEditionFactory;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.swt.widgets.Control;

public class ExpressionLanguageFactory
extends StringEditionFactory {
    private UniqueElementValidator validator = new UniqueElementValidator();
    private List<?> expressionList;

    public ExpressionLanguageFactory(List<?> currentExpressionList) {
        super(Messages.ExpressionLanguageFactory_EditLanguage, Messages.ExpressionLanguageFactory_SetNewLanguage);
        this.expressionList = currentExpressionList;
        this.setValidator(this.validator);
    }

    public Object edit(Control widget, Object currentValue) {
        if (currentValue instanceof ExpressionList.Expression) {
            String valueToEdit = ((ExpressionList.Expression)((Object)currentValue)).getLanguage();
            this.validator.setCurrentValue(valueToEdit);
            String newValue = (String)super.edit(widget, (Object)valueToEdit);
            ((ExpressionList.Expression)((Object)currentValue)).setLanguage(newValue);
        }
        return currentValue;
    }

    public Object createObject(Control widget, Object context) {
        String languageName = (String)super.createObject(widget, context);
        if (languageName == null) {
            return null;
        }
        ExpressionList.Expression expression = new ExpressionList.Expression();
        expression.setLanguage(languageName);
        return expression;
    }

    private class UniqueElementValidator
    implements IInputValidator {
        private String currentValue;

        private UniqueElementValidator() {
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }

        public String isValid(String newText) {
            if (newText.equals(this.currentValue)) {
                return null;
            }
            for (Object object : ExpressionLanguageFactory.this.expressionList) {
                ExpressionList.Expression expression;
                if (!(object instanceof ExpressionList.Expression) || !newText.equals((expression = (ExpressionList.Expression)((Object)object)).getLanguage())) continue;
                return Messages.ExpressionLanguageFactory_LanguageDuplicateError;
            }
            return null;
        }
    }
}

