/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractEMFModelElementFactory;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElementFactory;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeModelElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeModelElementFactory
extends EMFModelElementFactory {
    protected EMFModelElement doCreateFromSource(Object source, DataContextElement context) {
        Element umlElement = UMLUtil.resolveUMLElement((Object)source);
        if (umlElement != null) {
            EObject stereotypeApplication;
            Stereotype stereotype = UMLUtil.getAppliedSuperstereotype((Element)umlElement, (String)this.getQualifiedName(context));
            Stereotype actual = stereotype == null ? null : UMLUtil.getAppliedSubstereotype((Element)umlElement, (Stereotype)stereotype);
            EObject eObject = stereotypeApplication = actual == null ? null : umlElement.getStereotypeApplication(actual);
            if (stereotypeApplication == null) {
                Activator.log.warn("Stereotype " + this.getQualifiedName(context) + " is not applied on " + String.valueOf(umlElement));
            } else {
                EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)stereotypeApplication);
                return new StereotypeModelElement(stereotypeApplication, stereotype, domain);
            }
        }
        return null;
    }

    protected void updateModelElement(EMFModelElement modelElement, Object newSourceElement) {
        if (!(modelElement instanceof StereotypeModelElement)) {
            Activator.log.warn(String.format("Not a stereotype element: %s", modelElement));
        } else {
            StereotypeModelElement stereotypeElement = (StereotypeModelElement)modelElement;
            Element umlElement = UMLUtil.resolveUMLElement((Object)newSourceElement);
            if (umlElement == null) {
                Activator.log.warn(String.format("Missing UML element in stereotype model element: %s", modelElement));
            } else {
                EObject stereotypeApplication;
                Stereotype actual = UMLUtil.getAppliedSubstereotype((Element)umlElement, (Stereotype)stereotypeElement.stereotype);
                EObject eObject = stereotypeApplication = actual == null ? null : umlElement.getStereotypeApplication(actual);
                if (stereotypeApplication == null) {
                    Activator.log.warn(String.format("Stereotype '%s' is not applied on '%s'", stereotypeElement.stereotype.getQualifiedName(), umlElement));
                } else {
                    AbstractEMFModelElementFactory.updateEMFModelElement((EMFModelElement)modelElement, (EObject)stereotypeApplication);
                }
            }
        }
    }

    protected String getQualifiedName(DataContextElement context) {
        if (context.getPackage() == null) {
            return context.getName();
        }
        return this.getQualifiedName((DataContextElement)context.getPackage()) + "::" + context.getName();
    }
}

