/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.widgets.layout.PropertiesLayout;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.properties.modelelement.StereotypeApplicationModelElement;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.AppliedStereotypeCompositeWithView;
import org.eclipse.papyrus.uml.properties.widgets.StereotypePropertyEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;

public class StereotypeApplication
extends AbstractPropertyEditor {
    private AppliedStereotypeCompositeWithView stereotypeComposite;
    private Composite self;

    public StereotypeApplication(Composite parent, int style) {
        this.self = new Composite(parent, style);
        this.self.setLayout((Layout)new PropertiesLayout(2, true));
        int heightHint = 200;
        this.stereotypeComposite = new AppliedStereotypeCompositeWithView(this.self);
        this.stereotypeComposite.createContent(this.self, AbstractEditor.factory);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = heightHint;
        this.stereotypeComposite.setLayoutData(data);
        StereotypePropertyEditor propertyEditor = new StereotypePropertyEditor(this.self, style, this.stereotypeComposite);
        data = new GridData(4, 4, true, false);
        data.heightHint = heightHint;
        propertyEditor.setLayoutData(data);
        this.stereotypeComposite.setPropertySelectionChangeListener(propertyEditor);
    }

    protected void doBinding() {
        ModelElement element = this.input.getModelElement(this.propertyPath);
        if (element instanceof StereotypeApplicationModelElement) {
            this.internalDoBinding();
            final IObservable property = this.input.getObservable(this.propertyPath);
            property.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    if (StereotypeApplication.this.self == null || StereotypeApplication.this.self.isDisposed()) {
                        property.removeChangeListener((IChangeListener)this);
                    } else {
                        StereotypeApplication.this.internalDoBinding();
                    }
                }
            });
        }
    }

    protected void internalDoBinding() {
        ModelElement element = this.input.getModelElement(this.propertyPath);
        if (element instanceof StereotypeApplicationModelElement) {
            StereotypeApplicationModelElement modelElement = (StereotypeApplicationModelElement)element;
            View diagramElement = (View)modelElement.getGraphicalElement();
            Element umlElement = modelElement.getUMLElement();
            if (this.stereotypeComposite.getElement() != umlElement) {
                this.stereotypeComposite.setElement(umlElement);
                this.stereotypeComposite.setInput(new StereotypedElementTreeObject(umlElement));
            }
            this.stereotypeComposite.setDiagramElement((EModelElement)diagramElement);
            this.stereotypeComposite.refresh();
        }
    }
}

