/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.services.internal.preferences;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.papyrus.views.properties.services.Activator;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProviderService;
import org.eclipse.papyrus.views.properties.services.internal.messages.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PropertiesRenderingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor radioGroupFieldEditor;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        List<String> renderers = this.getRenderers();
        String[][] array = new String[renderers.size()][2];
        int i = 0;
        Iterator<String> iterator = renderers.iterator();
        while (iterator.hasNext()) {
            String delegate;
            array[i][0] = delegate = iterator.next();
            array[i][1] = delegate;
            ++i;
        }
        this.radioGroupFieldEditor = new RadioGroupFieldEditor("PREFERRED_RENDERER", Messages.SelectTheRendererToUse, 1, array, this.getFieldEditorParent());
        this.addField((FieldEditor)this.radioGroupFieldEditor);
    }

    private List<String> getRenderers() {
        IPropertySheetPageProviderService provider;
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference servreg = Activator.getDefault().getBundle().getBundleContext().getServiceReference(IPropertySheetPageProviderService.class);
        if (servreg != null && (provider = (IPropertySheetPageProviderService)bundleContext.getService(servreg)) != null) {
            return provider.getAvailableRenderers();
        }
        return Collections.emptyList();
    }
}

