/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.pde.bnd.ui.ResourceUtils;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.ResourceProvider;
import org.osgi.resource.Resource;

public class RepositoryResourceElement
implements ResourceProvider,
IAdaptable {
    private final Resource resource;
    private final String name;
    private final RepositoryBundleVersion repositoryBundleVersion;

    RepositoryResourceElement(RepositoryPlugin repoPlugin, Resource resource) {
        this.resource = resource;
        this.name = ResourceUtils.getIdentity(resource);
        this.repositoryBundleVersion = new RepositoryBundleVersion(new RepositoryBundle(repoPlugin, this.name), Version.parseVersion((String)this.getVersionString()));
    }

    public RepositoryBundleVersion getRepositoryBundleVersion() {
        return this.repositoryBundleVersion;
    }

    String getIdentity() {
        return this.name;
    }

    String getVersionString() {
        org.osgi.framework.Version version = ResourceUtils.getVersion(this.resource);
        if (version == null) {
            version = org.osgi.framework.Version.emptyVersion;
        }
        return version.toString();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return this.repositoryBundleVersion.getAdapter(adapter);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryResourceElement other = (RepositoryResourceElement)obj;
        return Objects.equals(this.resource, other.resource);
    }
}

