/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.bndtools;

import java.util.Collection;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.TreeContentProvider;
import org.eclipse.pde.internal.ui.shared.target.IEditBundleContainerPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public abstract class BndTargetLocationPage
extends WizardPage
implements IEditBundleContainerPage {
    private final String message;
    private final ITargetDefinition targetDefinition;
    private static final Image bundleIcon = PDEPluginImages.get("/icons/bndtools/bundle.png");

    public BndTargetLocationPage(String pageName, String title, String message, ITargetDefinition targetDefinition) {
        super(pageName);
        this.setTitle(title);
        this.setMessage(message);
        this.message = message;
        this.targetDefinition = targetDefinition;
    }

    public ITargetDefinition getTargetDefinition() {
        return this.targetDefinition;
    }

    protected void logError(String message, Exception e) {
        ILog.get().error(message, (Throwable)e);
        this.setMessage(message, 3);
    }

    protected void logWarning(String message, Exception e) {
        ILog.get().warn(message, (Throwable)e);
        this.setMessage(message, 2);
    }

    protected void resetMessage() {
        this.setMessage(this.message);
    }

    protected TreeViewer createBundleListArea(Composite composite, int hSpan) {
        TreeViewer bundleList = new TreeViewer(new Tree(composite, 2820));
        bundleList.getTree().setLayoutData(this.fillGridData(hSpan));
        bundleList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return bundleIcon;
            }
        });
        bundleList.setContentProvider((IContentProvider)new TreeContentProvider(){

            @Override
            public Object[] getElements(Object element) {
                return ((Collection)element).toArray();
            }
        });
        return bundleList;
    }

    protected Object fillGridData(int hSpan) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = hSpan;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    @Override
    public void storeSettings() {
    }
}

