/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.pde.internal.core.natures.BndProject;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertAutomaticManifestsWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertAutomaticManifestAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection iSelection;
        if (PlatformUI.getWorkbench().saveAllEditors(true) && (iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)iSelection;
            List<IProject> projects = selection.stream().map(ConvertAutomaticManifestAction::toProject).filter(Objects::nonNull).filter(proj -> PDE.hasPluginNature((IProject)proj)).filter(proj -> !BndProject.isBndProject((IProject)proj)).toList();
            if (projects.isEmpty()) {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.ConvertAutomaticManifestWizardPage_title, (String)PDEUIMessages.OrganizeManifestsWizardPage_errorMsg);
                return null;
            }
            RefactoringWizardOpenOperation refactoringOperation = new RefactoringWizardOpenOperation((RefactoringWizard)new ConvertAutomaticManifestsWizard(projects));
            try {
                refactoringOperation.run(PDEPlugin.getActiveWorkbenchShell(), PDEUIMessages.ConvertAutomaticManifestWizardPage_title);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    private static IProject toProject(Object object) {
        if (object instanceof IJavaProject) {
            IJavaProject java = (IJavaProject)object;
            return java.getProject();
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            return resource.getProject();
        }
        return null;
    }
}

